/*
 * Decompiled with CFR 0.152.
 */
package JSci.io;

import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ExtraMath;
import JSci.maths.MathDouble;
import JSci.maths.MathSet;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.RealField;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.Complex3Vector;
import JSci.maths.vectors.Double3Vector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class MathMLExpression {
    private String operation;
    private List args = new ArrayList();

    public void setOperation(String string) {
        this.operation = string;
    }

    public String getOperation() {
        return this.operation;
    }

    public void addArgument(Object object) {
        this.args.add(object);
    }

    public Object getArgument(int n) {
        return this.args.get(n);
    }

    public int length() {
        return this.args.size();
    }

    public MathMLExpression substitute(String string, Object object) {
        MathMLExpression mathMLExpression = new MathMLExpression();
        mathMLExpression.operation = this.operation;
        for (int i = 0; i < this.length(); ++i) {
            Object object2 = this.getArgument(i);
            if (object2 instanceof MathMLExpression) {
                object2 = ((MathMLExpression)object2).substitute(string, object);
            } else if (object2.equals(string)) {
                object2 = object;
            }
            mathMLExpression.addArgument(object2);
        }
        return mathMLExpression;
    }

    public MathMLExpression substitute(Map map) {
        MathMLExpression mathMLExpression = new MathMLExpression();
        mathMLExpression.operation = this.operation;
        for (int i = 0; i < this.length(); ++i) {
            Object object = this.getArgument(i);
            if (object instanceof MathMLExpression) {
                object = ((MathMLExpression)object).substitute(map);
            } else if (map.containsKey(object)) {
                object = map.get(object);
            }
            mathMLExpression.addArgument(object);
        }
        return mathMLExpression;
    }

    public Object evaluate() {
        if (this.length() == 1) {
            return this.unaryEvaluate();
        }
        if (this.length() == 2) {
            return this.binaryEvaluate();
        }
        return this.nAryEvaluate();
    }

    private Object unaryEvaluate() {
        Object object = this.getArgument(0);
        if (object instanceof MathMLExpression) {
            object = ((MathMLExpression)object).evaluate();
        }
        if (this.operation.equals("abs")) {
            object = object instanceof Number ? new MathDouble(Math.abs(((Number)object).doubleValue())) : (object instanceof Complex ? new MathDouble(((Complex)object).mod()) : "|" + object + "|");
        } else if (this.operation.equals("minus")) {
            object = object instanceof AbelianGroup.Member ? ((AbelianGroup.Member)object).negate() : "-(" + object + ")";
        } else if (this.operation.equals("arg")) {
            object = object instanceof Number ? (((Number)object).doubleValue() >= 0.0 ? RealField.ZERO : RealField.PI) : (object instanceof Complex ? new MathDouble(((Complex)object).arg()) : "arg(" + object + ")");
        } else if (this.operation.equals("real")) {
            object = object instanceof Complex ? new MathDouble(((Complex)object).real()) : (object instanceof AbstractComplexVector ? ((AbstractComplexVector)object).real() : (object instanceof AbstractComplexMatrix ? ((AbstractComplexMatrix)object).real() : "re(" + object + ")"));
        } else if (this.operation.equals("imaginary")) {
            object = object instanceof Complex ? new MathDouble(((Complex)object).imag()) : (object instanceof AbstractComplexVector ? ((AbstractComplexVector)object).imag() : (object instanceof AbstractComplexMatrix ? ((AbstractComplexMatrix)object).imag() : "im(" + object + ")"));
        } else if (this.operation.equals("conjugate")) {
            object = object instanceof Complex ? ((Complex)object).conjugate() : (object instanceof AbstractComplexVector ? ((AbstractComplexVector)object).conjugate() : (object instanceof AbstractComplexMatrix ? ((AbstractComplexMatrix)object).conjugate() : "(" + object + ")*"));
        } else if (this.operation.equals("transpose")) {
            object = object instanceof Matrix ? ((Matrix)object).transpose() : "(" + object + ")^T";
        } else if (this.operation.equals("exp")) {
            object = object instanceof Number ? MathDouble.exp((Number)object) : (object instanceof Complex ? Complex.exp((Complex)object) : "exp(" + object + ")");
        } else if (this.operation.equals("ln")) {
            object = object instanceof Number ? MathDouble.log((Number)object) : (object instanceof Complex ? Complex.log((Complex)object) : "log(" + object + ")");
        } else if (this.operation.equals("sin")) {
            object = object instanceof Number ? MathDouble.sin((Number)object) : (object instanceof Complex ? Complex.sin((Complex)object) : "sin(" + object + ")");
        } else if (this.operation.equals("cos")) {
            object = object instanceof Number ? MathDouble.cos((Number)object) : (object instanceof Complex ? Complex.cos((Complex)object) : "cos(" + object + ")");
        } else if (this.operation.equals("tan")) {
            object = object instanceof Number ? MathDouble.tan((Number)object) : (object instanceof Complex ? Complex.tan((Complex)object) : "tan(" + object + ")");
        } else if (this.operation.equals("arcsin")) {
            object = object instanceof Number ? MathDouble.asin((Number)object) : (object instanceof Complex ? Complex.asin((Complex)object) : "arcsin(" + object + ")");
        } else if (this.operation.equals("arccos")) {
            object = object instanceof Number ? MathDouble.acos((Number)object) : (object instanceof Complex ? Complex.acos((Complex)object) : "arccos(" + object + ")");
        } else if (this.operation.equals("arctan")) {
            object = object instanceof Number ? MathDouble.atan((Number)object) : (object instanceof Complex ? Complex.atan((Complex)object) : "arctan(" + object + ")");
        } else if (this.operation.equals("sinh")) {
            object = object instanceof Number ? MathDouble.sinh((Number)object) : (object instanceof Complex ? Complex.sinh((Complex)object) : "sinh(" + object + ")");
        } else if (this.operation.equals("cosh")) {
            object = object instanceof Number ? MathDouble.cosh((Number)object) : (object instanceof Complex ? Complex.cosh((Complex)object) : "cosh(" + object + ")");
        } else if (this.operation.equals("tanh")) {
            object = object instanceof Number ? MathDouble.tanh((Number)object) : (object instanceof Complex ? Complex.tanh((Complex)object) : "tanh(" + object + ")");
        } else if (this.operation.equals("factorial")) {
            object = object instanceof Number ? new MathDouble(ExtraMath.factorial(((Number)object).doubleValue())) : "(" + object + ")!";
        } else if (this.operation.equals("not")) {
            object = object instanceof Boolean ? new Boolean((Boolean)object == false) : "!(" + object + ")";
        }
        return object;
    }

    private Object binaryEvaluate() {
        Object object;
        Object object2 = this.getArgument(0);
        if (object2 instanceof MathMLExpression) {
            object2 = ((MathMLExpression)object2).evaluate();
        }
        if ((object = this.getArgument(1)) instanceof MathMLExpression) {
            object = ((MathMLExpression)object).evaluate();
        }
        if (this.operation.equals("minus")) {
            object2 = object2 instanceof AbelianGroup.Member && object instanceof AbelianGroup.Member ? ((AbelianGroup.Member)object2).subtract((AbelianGroup.Member)object) : "(" + object2 + ")-(" + object + ")";
        } else if (this.operation.equals("divide")) {
            object2 = object instanceof Field.Member ? (object2 instanceof Field.Member ? ((Field.Member)object2).divide((Field.Member)object) : (object2 instanceof VectorSpace.Member ? ((VectorSpace.Member)object2).scalarDivide((Field.Member)object) : "(" + object2 + ")/(" + object + ")")) : "(" + object2 + ")/(" + object + ")";
        } else if (this.operation.equals("scalarproduct")) {
            object2 = object2 instanceof AbstractDoubleVector && object instanceof AbstractDoubleVector ? new MathDouble(((AbstractDoubleVector)object2).scalarProduct((AbstractDoubleVector)object)) : (object2 instanceof AbstractComplexVector && object instanceof AbstractComplexVector ? ((AbstractComplexVector)object2).scalarProduct((AbstractComplexVector)object) : "(" + object2 + ").(" + object + ")");
        } else if (this.operation.equals("vectorproduct")) {
            object2 = object2 instanceof Double3Vector && object instanceof Double3Vector ? ((Double3Vector)object2).multiply((Double3Vector)object) : (object2 instanceof Complex3Vector && object instanceof Complex3Vector ? ((Complex3Vector)object2).multiply((Complex3Vector)object) : "(" + object2 + ")x(" + object2 + ")");
        } else if (this.operation.equals("power")) {
            object2 = object2 instanceof Number && object instanceof Number ? new MathDouble(Math.pow(((Number)object2).doubleValue(), ((Number)object).doubleValue())) : "(" + object2 + ")^(" + object2 + ")";
        } else if (this.operation.equals("neq")) {
            object2 = new Boolean(!object2.equals(object));
        } else {
            return this.nAryEvaluate();
        }
        return object2;
    }

    private Object nAryEvaluate() {
        Object object = this.getArgument(0);
        if (object instanceof MathMLExpression) {
            object = ((MathMLExpression)object).evaluate();
        }
        if (this.operation.equals("plus")) {
            for (int i = 1; i < this.length(); ++i) {
                Object object2 = this.getArgument(i);
                if (object2 instanceof MathMLExpression) {
                    object2 = ((MathMLExpression)object2).evaluate();
                }
                object = object instanceof AbelianGroup.Member && object2 instanceof AbelianGroup.Member ? ((AbelianGroup.Member)object).add((AbelianGroup.Member)object2) : "(" + object + ")+(" + object2 + ")";
            }
        } else if (this.operation.equals("times")) {
            for (int i = 1; i < this.length(); ++i) {
                Object object3 = this.getArgument(i);
                if (object3 instanceof MathMLExpression) {
                    object3 = ((MathMLExpression)object3).evaluate();
                }
                object = object instanceof Ring.Member && object3 instanceof Ring.Member ? ((Ring.Member)object).multiply((Ring.Member)object3) : (object instanceof Module.Member && object3 instanceof Module.Member ? ((Module.Member)object3).scalarMultiply((Ring.Member)object) : "(" + object + ")*(" + object3 + ")");
            }
        } else if (this.operation.equals("min")) {
            for (int i = 1; i < this.length(); ++i) {
                Object object4 = this.getArgument(i);
                if (object4 instanceof MathMLExpression) {
                    object4 = ((MathMLExpression)object4).evaluate();
                }
                if (!(object instanceof Comparable) || ((Comparable)object).compareTo(object4) <= 0) continue;
                object = object4;
            }
        } else if (this.operation.equals("max")) {
            for (int i = 1; i < this.length(); ++i) {
                Object object5 = this.getArgument(i);
                if (object5 instanceof MathMLExpression) {
                    object5 = ((MathMLExpression)object5).evaluate();
                }
                if (!(object instanceof Comparable) || ((Comparable)object).compareTo(object5) >= 0) continue;
                object = object5;
            }
        } else if (this.operation.equals("mean")) {
            object = new MathDouble(this.mean());
        } else if (this.operation.equals("sdev")) {
            object = new MathDouble(Math.sqrt(this.variance()));
        } else if (this.operation.equals("var")) {
            object = new MathDouble(this.variance());
        } else if (this.operation.equals("median")) {
            double[] dArray = new double[this.length()];
            dArray[0] = ((Number)object).doubleValue();
            for (int i = 1; i < dArray.length; ++i) {
                Object object6 = this.getArgument(i);
                if (object6 instanceof MathMLExpression) {
                    object6 = ((MathMLExpression)object6).evaluate();
                }
                dArray[i] = ((Number)object6).doubleValue();
            }
            object = new MathDouble(ArrayMath.median(dArray));
        } else if (this.operation.equals("union")) {
            if (object instanceof MathSet) {
                MathSet mathSet = (MathSet)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object7 = this.getArgument(i);
                    if (object7 instanceof MathMLExpression) {
                        object7 = ((MathMLExpression)object7).evaluate();
                    }
                    if (!(object7 instanceof MathSet)) continue;
                    mathSet = mathSet.union((MathSet)object7);
                }
                object = mathSet;
            }
        } else if (this.operation.equals("intersect")) {
            if (object instanceof MathSet) {
                MathSet mathSet = (MathSet)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object8 = this.getArgument(i);
                    if (object8 instanceof MathMLExpression) {
                        object8 = ((MathMLExpression)object8).evaluate();
                    }
                    if (!(object8 instanceof MathSet)) continue;
                    mathSet = mathSet.intersect((MathSet)object8);
                }
                object = mathSet;
            }
        } else if (this.operation.equals("and")) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object9 = this.getArgument(i);
                    if (object9 instanceof MathMLExpression) {
                        object9 = ((MathMLExpression)object9).evaluate();
                    }
                    if (!(object9 instanceof Boolean)) continue;
                    bl &= ((Boolean)object9).booleanValue();
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("or")) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object10 = this.getArgument(i);
                    if (object10 instanceof MathMLExpression) {
                        object10 = ((MathMLExpression)object10).evaluate();
                    }
                    if (!(object10 instanceof Boolean)) continue;
                    bl |= ((Boolean)object10).booleanValue();
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("xor")) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object11 = this.getArgument(i);
                    if (object11 instanceof MathMLExpression) {
                        object11 = ((MathMLExpression)object11).evaluate();
                    }
                    if (!(object11 instanceof Boolean)) continue;
                    bl ^= ((Boolean)object11).booleanValue();
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("eq")) {
            Object object12 = object;
            boolean bl = true;
            for (int i = 1; i < this.length(); ++i) {
                Object object13 = this.getArgument(i);
                if (object13 instanceof MathMLExpression) {
                    object13 = ((MathMLExpression)object13).evaluate();
                }
                bl &= object12.equals(object13);
                object12 = object13;
            }
            object = new Boolean(bl);
        } else if (this.operation.equals("lt")) {
            if (object instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                boolean bl = true;
                for (int i = 1; i < this.length(); ++i) {
                    Object object14 = this.getArgument(i);
                    if (object14 instanceof MathMLExpression) {
                        object14 = ((MathMLExpression)object14).evaluate();
                    }
                    bl &= comparable.compareTo(object14) < 0;
                    if (!(object14 instanceof Comparable)) continue;
                    comparable = (Comparable)object14;
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("leq")) {
            if (object instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                boolean bl = true;
                for (int i = 1; i < this.length(); ++i) {
                    Object object15 = this.getArgument(i);
                    if (object15 instanceof MathMLExpression) {
                        object15 = ((MathMLExpression)object15).evaluate();
                    }
                    bl &= comparable.compareTo(object15) <= 0;
                    if (!(object15 instanceof Comparable)) continue;
                    comparable = (Comparable)object15;
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("gt")) {
            if (object instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                boolean bl = true;
                for (int i = 1; i < this.length(); ++i) {
                    Object object16 = this.getArgument(i);
                    if (object16 instanceof MathMLExpression) {
                        object16 = ((MathMLExpression)object16).evaluate();
                    }
                    bl &= comparable.compareTo(object16) > 0;
                    if (!(object16 instanceof Comparable)) continue;
                    comparable = (Comparable)object16;
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("geq") && object instanceof Comparable) {
            Comparable comparable = (Comparable)object;
            boolean bl = true;
            for (int i = 1; i < this.length(); ++i) {
                Object object17 = this.getArgument(i);
                if (object17 instanceof MathMLExpression) {
                    object17 = ((MathMLExpression)object17).evaluate();
                }
                bl &= comparable.compareTo(object17) >= 0;
                if (!(object17 instanceof Comparable)) continue;
                comparable = (Comparable)object17;
            }
            object = new Boolean(bl);
        }
        return object;
    }

    private double mean() {
        double d = ((Number)this.getArgument(0)).doubleValue();
        for (int i = 1; i < this.length(); ++i) {
            Object object = this.getArgument(i);
            if (object instanceof MathMLExpression) {
                object = ((MathMLExpression)object).evaluate();
            }
            d += ((Number)object).doubleValue();
        }
        return d / (double)this.length();
    }

    private double variance() {
        double d = this.mean();
        double d2 = ((Number)this.getArgument(0)).doubleValue();
        double d3 = (d2 - d) * (d2 - d);
        for (int i = 1; i < this.length(); ++i) {
            Object object = this.getArgument(i);
            if (object instanceof MathMLExpression) {
                object = ((MathMLExpression)object).evaluate();
            }
            d2 = ((Number)object).doubleValue();
            d3 += (d2 - d) * (d2 - d);
        }
        return d3 / (double)(this.length() - 1);
    }
}

