/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.quantum;

import JSci.maths.AbstractMath;
import JSci.maths.Complex;
import JSci.physics.quantum.DensityMatrix;
import JSci.physics.quantum.KetVector;
import JSci.physics.quantum.Operator;
import JSci.physics.quantum.Projector;

public final class QuantumMath
extends AbstractMath {
    private QuantumMath() {
    }

    public static Operator commutator(Operator operator, Operator operator2) {
        return operator.multiply(operator2).subtract(operator2.multiply(operator));
    }

    public static Operator anticommutator(Operator operator, Operator operator2) {
        return operator.multiply(operator2).add(operator2.multiply(operator));
    }

    public static Complex expectation(Operator operator, KetVector ketVector) {
        return ketVector.toBraVector().multiply(operator).multiply(ketVector);
    }

    public static Complex expectation(DensityMatrix densityMatrix, Operator operator) {
        return densityMatrix.multiply(operator).trace();
    }

    public static Complex probability(Projector projector, KetVector ketVector) {
        return ketVector.toBraVector().multiply(projector).multiply(ketVector);
    }

    public static Complex probability(DensityMatrix densityMatrix, Projector projector) {
        return densityMatrix.multiply(projector).trace();
    }
}

