/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtTypeImpl;
import spoon.support.reflect.eval.VisitorPartialEvaluator;

public class CtClassImpl<T>
extends CtTypeImpl<T>
implements CtClass<T> {
    private static final long serialVersionUID = 1L;
    List<CtAnonymousExecutable> anonymousExecutables = CtClassImpl.EMPTY_LIST();
    Set<CtConstructor<T>> constructors = CtClassImpl.EMPTY_SET();
    CtTypeReference<?> superClass;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtClass(this);
    }

    @Override
    public Set<CtMethod<?>> getAllMethods() {
        TreeSet ret = new TreeSet();
        ret.addAll(this.getMethods());
        if (this.getSuperclass() != null && this.getSuperclass().getDeclaration() != null) {
            CtType t = (CtType)this.getSuperclass().getDeclaration();
            ret.addAll(t.getAllMethods());
        }
        return ret;
    }

    @Override
    public List<CtAnonymousExecutable> getAnonymousExecutables() {
        return this.anonymousExecutables;
    }

    @Override
    public CtConstructor<T> getConstructor(CtTypeReference<?> ... parameterTypes) {
        for (CtConstructor<T> c : this.constructors) {
            boolean cont = c.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < c.getParameters().size() && i < parameterTypes.length; ++i) {
                if (c.getParameters().get(i).getType().getQualifiedName().equals(parameterTypes[i].getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return c;
        }
        return null;
    }

    @Override
    public Set<CtConstructor<T>> getConstructors() {
        return this.constructors;
    }

    @Override
    public boolean addAnonymousExecutable(CtAnonymousExecutable e) {
        if (this.anonymousExecutables == CtElementImpl.EMPTY_LIST()) {
            this.anonymousExecutables = new ArrayList<CtAnonymousExecutable>();
        }
        return this.anonymousExecutables.add(e);
    }

    @Override
    public boolean removeAnonymousExecutable(CtAnonymousExecutable e) {
        if (this.anonymousExecutables == CtElementImpl.EMPTY_LIST()) {
            this.anonymousExecutables = new ArrayList<CtAnonymousExecutable>();
        }
        return this.anonymousExecutables.remove(e);
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return this.superClass;
    }

    @Override
    public void setAnonymousExecutables(List<CtAnonymousExecutable> e) {
        this.anonymousExecutables = e;
    }

    @Override
    public void setConstructors(Set<CtConstructor<T>> constructors) {
        this.constructors = constructors;
    }

    @Override
    public void addConstructor(CtConstructor<T> constructor) {
        if (this.constructors == CtElementImpl.EMPTY_SET()) {
            this.constructors = new TreeSet<CtConstructor<T>>();
        }
        constructor.setParent(this);
        this.constructors.add(constructor);
    }

    @Override
    public void removeConstructor(CtConstructor<T> constructor) {
        if (this.constructors == CtElementImpl.EMPTY_SET()) {
            this.constructors = new TreeSet<CtConstructor<T>>();
        }
        this.constructors.remove(constructor);
    }

    @Override
    public void setSuperclass(CtTypeReference<?> superClass) {
        this.superClass = superClass;
    }

    @Override
    public boolean isAnonymous() {
        try {
            Integer.parseInt(this.getSimpleName());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        if (this.getSuperclass() != null && this.getSuperclass().isSubtypeOf(type)) {
            return true;
        }
        for (CtTypeReference<?> ref : this.getSuperInterfaces()) {
            if (!ref.isSubtypeOf(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void insertAfter(CtStatement statement) {
        CtStatementImpl.insertAfter((CtStatement)this, statement);
    }

    @Override
    public void insertAfter(CtStatementList statements) {
        CtStatementImpl.insertAfter((CtStatement)this, statements);
    }

    @Override
    public void insertBefore(CtStatement statement) {
        CtStatementImpl.insertBefore((CtStatement)this, statement);
    }

    @Override
    public void insertBefore(CtStatementList statements) {
        CtStatementImpl.insertBefore((CtStatement)this, statements);
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public void setLabel(String label) {
        throw new UnsupportedOperationException("cannot set a label on a class declaration");
    }

    @Override
    public <R extends CtCodeElement> R partiallyEvaluate() {
        VisitorPartialEvaluator eval = new VisitorPartialEvaluator();
        return (R)eval.evaluate(this.getParent(), this);
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        ArrayList l = new ArrayList(super.getDeclaredExecutables());
        for (CtExecutable ctExecutable : this.getConstructors()) {
            l.add(ctExecutable.getReference());
        }
        return Collections.unmodifiableCollection(l);
    }
}

