/*
 * Decompiled with CFR 0.152.
 */
package conifer.ssm;

import conifer.ssm.Edit;
import conifer.ssm.ForwardSimulator;
import conifer.ssm.StringMutationModel;
import conifer.ssm.Utils;
import fig.basic.Option;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.MSAPoset;
import nuts.util.Arbre;
import pty.RootedTree;

public class SSMDataGenerator {
    @Option
    public Random dataGenRand = new Random(1L);
    public StringMutationModel model;
    public Map<Taxon, String> sequences;
    public Map<Taxon, List<Edit>> edits;
    public RootedTree tree;

    public void generateData(StringMutationModel model, RootedTree tree) {
        this.sequences = new HashMap<Taxon, String>();
        this.edits = new HashMap<Taxon, List<Edit>>();
        this.model = model;
        this.tree = tree;
        this.generateData(tree.topology(), null);
    }

    public MSAPoset getSpeciationPointsAlignment() {
        HashSet<Taxon> points = new HashSet<Taxon>();
        for (Taxon t : this.tree.topology().nodeContents()) {
            points.add(t);
        }
        return MSAPoset.restrict(this.getFullAlignment(), points);
    }

    public MSAPoset getFullAlignment() {
        Map<Taxon, Taxon> parents = Arbre.parents(this.tree.topology());
        ArrayList<MSAPoset> pairAligns = new ArrayList<MSAPoset>();
        for (Taxon t : this.edits.keySet()) {
            Taxon parent = parents.get(t);
            List<Edit> curEdits = this.edits.get(t);
            String parentStr = this.sequences.get(parent);
            MSAPoset pair = Utils.toAlign(parentStr, curEdits, parent, t, "intermediate_" + t.toString() + "_");
            pairAligns.add(pair);
        }
        return MSAPoset.union(pairAligns);
    }

    private void generateData(Arbre<Taxon> topology, String parentSeqn) {
        ArrayList<Edit> curEdits = new ArrayList<Edit>();
        Taxon curTaxon = topology.getContents();
        String currentSeqns = parentSeqn == null ? ForwardSimulator.approxStationarySampling(this.model, this.dataGenRand) : ForwardSimulator.next(parentSeqn, this.model, this.tree.branchLengths().get(curTaxon), this.dataGenRand, curEdits);
        this.sequences.put(curTaxon, currentSeqns);
        if (parentSeqn != null) {
            this.edits.put(curTaxon, curEdits);
        }
        for (Arbre<Taxon> subt : topology.getChildren()) {
            this.generateData(subt, currentSeqns);
        }
    }
}

