/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.CompoundFunction;
import dr.math.Integral;
import dr.math.UnivariateFunction;
import dr.math.distributions.NormalDistribution;

public class RiemannApproximation
implements Integral {
    private int sampleSize;

    public RiemannApproximation(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @Override
    public double integrate(UnivariateFunction f, double min, double max) {
        double integral = 0.0;
        double gridpoint = min;
        double step = (max - min) / (double)this.sampleSize;
        for (int i = 1; i <= this.sampleSize; ++i) {
            integral += f.evaluate(gridpoint);
            gridpoint += step;
        }
        return integral *= (max - min) / (double)this.sampleSize;
    }

    public static void main(String[] args) {
        UnivariateFunction normalPDF = new NormalDistribution(0.0, 1.0).getProbabilityDensityFunction();
        UnivariateFunction normalPDF2 = new NormalDistribution(0.0, 1.0).getProbabilityDensityFunction();
        UnivariateFunction normalPDF3 = new NormalDistribution(0.0, 1.0).getProbabilityDensityFunction();
        double Z = 1.0;
        CompoundFunction threeNormals = new CompoundFunction(new UnivariateFunction[]{normalPDF, normalPDF2, normalPDF3}, Z);
        System.out.println("Riemann approximation to the integral of a three normal distribution:");
        RiemannApproximation integrator = new RiemannApproximation(100000);
        System.out.println("integral(N(0.0, 1.0))=" + integrator.integrate(normalPDF, -4.0, 4.0));
        System.out.println("integral(N(1.0, 2.0))=" + integrator.integrate(normalPDF2, -8.0, 8.0));
        System.out.println("integral(N(2.0, 3.0))=" + integrator.integrate(normalPDF3, -16.0, 16.0));
        double integral = integrator.integrate(threeNormals, -16.0, 16.0);
        System.out.println("Riemann approximation to the integral of the compound of three normal distribution:");
        System.out.println("integral(N(0.0, 1.0)*N(1.0, 2.0)*N(2.0, 3.0))=" + integral);
        System.out.println("Estimate normalizing constant is " + 1.0 / integral);
    }
}

