/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class OffsetPositiveDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return OffsetPositiveDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return OffsetPositiveDistribution.this.offset + OffsetPositiveDistribution.this.distribution.getProbabilityDensityFunction().getLowerBound();
        }

        @Override
        public final double getUpperBound() {
            return OffsetPositiveDistribution.this.offset + OffsetPositiveDistribution.this.distribution.getProbabilityDensityFunction().getUpperBound();
        }
    };
    private double offset = 0.0;
    private Distribution distribution;

    public OffsetPositiveDistribution(Distribution distribution, double offset) {
        if (offset < 0.0) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
        this.distribution = distribution;
    }

    @Override
    public final double pdf(double x) {
        if (this.offset < 0.0) {
            return 0.0;
        }
        return this.distribution.pdf(x - this.offset);
    }

    @Override
    public final double logPdf(double x) {
        if (this.offset < 0.0) {
            return Math.log(0.0);
        }
        return this.distribution.logPdf(x - this.offset);
    }

    @Override
    public final double cdf(double x) {
        if (this.offset < 0.0) {
            return 0.0;
        }
        return this.distribution.cdf(x - this.offset);
    }

    @Override
    public final double quantile(double y) {
        return this.distribution.quantile(y) + this.offset;
    }

    @Override
    public final double mean() {
        return this.distribution.mean() + this.offset;
    }

    @Override
    public final double variance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }
}

