/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.Poisson;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.PoissonDistributionImpl;

public class PoissonDistribution
implements Distribution {
    org.apache.commons.math.distribution.PoissonDistribution distribution;

    public PoissonDistribution(double mean) {
        this.distribution = new PoissonDistributionImpl(mean);
    }

    @Override
    public double pdf(double x) {
        return this.distribution.probability(x);
    }

    @Override
    public double logPdf(double x) {
        double pdf = this.distribution.probability(x);
        if (pdf == 0.0 || Double.isNaN(pdf)) {
            double mean = this.mean();
            return x * Math.log(mean) - Poisson.gammln(x + 1.0) - mean;
        }
        return Math.log(pdf);
    }

    @Override
    public double cdf(double x) {
        try {
            return this.distribution.cumulativeProbability(x);
        }
        catch (MathException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double quantile(double y) {
        try {
            return this.distribution.inverseCumulativeProbability(y);
        }
        catch (MathException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double mean() {
        return this.distribution.getMean();
    }

    @Override
    public double variance() {
        return this.distribution.getMean();
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException();
    }

    public double truncatedMean(int max) {
        double CDF = 0.0;
        double mean = 0.0;
        for (int i = 0; i <= max; ++i) {
            double p = this.distribution.probability(i);
            mean += (double)i * p;
            CDF += p;
        }
        return mean / CDF;
    }
}

