/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;

public class CholeskyDecomposition {
    private int n;
    private boolean isspd;
    private double[][] L;

    public boolean isSPD() {
        return this.isspd;
    }

    public double[][] getL() {
        return this.L;
    }

    public CholeskyDecomposition(double[][] A) throws IllegalDimension {
        this.n = A.length;
        this.L = new double[this.n][this.n];
        boolean bl = this.isspd = A[0].length == this.n;
        if (!this.isspd) {
            throw new IllegalDimension("Cholesky decomposition is only defined for square matrices");
        }
        for (int j = 0; j < this.n; ++j) {
            double[] Lrowj = this.L[j];
            double d = 0.0;
            for (int k = 0; k < j; ++k) {
                double[] Lrowk = this.L[k];
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += Lrowk[i] * Lrowj[i];
                }
                Lrowj[k] = s = (A[j][k] - s) / this.L[k][k];
                d += s * s;
                this.isspd &= A[k][j] == A[j][k];
            }
            this.isspd &= (d = A[j][j] - d) > 0.0;
            this.L[j][j] = Math.sqrt(Math.max(d, 0.0));
        }
    }
}

