/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.ex.DataGenerator;
import ev.ex.NJPState;
import ev.ex.NJStateKernel;
import ev.ex.PhyloSamplerMain;
import ev.poi.processors.TreeDistancesProcessor;
import ev.to.MrBayes;
import ev.to.NJ;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import ma.MSAParser;
import ma.MSAPoset;
import ma.SequenceType;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.StatisticsMap;
import nuts.tui.Table;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.io.Dataset;
import pty.io.TreeEvaluator;
import pty.mcmc.PhyloSampler;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;
import pty.smc.LazyPCS;
import pty.smc.LazyParticleFilter;
import pty.smc.LazyPriorPrior;
import pty.smc.NCPriorPriorCondKernel;
import pty.smc.NCPriorPriorKernel;
import pty.smc.PG;
import pty.smc.PMCMC;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import pty.smc.PriorPriorKernel;
import pty.smc.models.CTMC;
import pty.smc.models.DiscreteModelCalculator;
import pty.smc.test.TestBrownianModel;

public class InferenceExperiments
implements Runnable {
    @Option
    public ParticleFilter.ResamplingStrategy resamplingStrategy = ParticleFilter.ResamplingStrategy.ALWAYS;
    @Option
    public boolean resampleRoot = false;
    @Option
    public double nThousandIters = 10.0;
    @Option
    public ArrayList<InferenceMethod> methods = CollUtils.list(Arrays.asList(InferenceMethod.MCMC));
    @Option
    public InferenceMethod refMethod = null;
    @Option
    public int refIterScaling = 100;
    @Option
    public ArrayList<Double> iterScalings = CollUtils.list(Arrays.asList(1.0));
    @Option
    public ComparisonType comparisonType = ComparisonType.TREE;
    @Option
    public int repPerDataPt = 1;
    @Option
    public String classToLoad = "poset.SMCAdapter";
    @Option
    public Random mainRand = new Random(1L);
    @Option
    public boolean usePriorPost = false;
    @Option
    public boolean verbose = false;
    @Option
    public int nThreads = 1;
    @Option
    public boolean useSimple = false;
    @Option
    public int maxNUniqueParticles = Integer.MAX_VALUE;
    @Option
    public int finalMaxNUniqueParticles = Integer.MAX_VALUE;
    @Option
    public double pmcmcSMCExpMix = 0.6666666666666666;
    public static DataGenerator.DataGeneratorMain generator = new DataGenerator.DataGeneratorMain();
    public static PhyloSamplerMain samplerMain = new PhyloSamplerMain();
    public static File data = null;
    private File output = null;

    public static void main(String[] args) {
        IO.run(args, new InferenceExperiments(), "dmc", DiscreteModelCalculator.class, "pcs", PartialCoalescentState.class, "mb", MrBayes.instance, "gen", generator, "mcmc", samplerMain, "prop", ProposalDistribution.Util._defaultProposalDistributionOptions, "phylo", PhyloSampler._defaultPhyloSamplerOptions, "prior", PhyloSampler._defaultPriorOptions, "nj", NJ.class, "lazyp", LazyPriorPrior.class, "nc", NCPriorPriorKernel.class);
    }

    protected void treeComparison() {
        PrintWriter out = IOUtils.openOutEasy(new File(this.output, "results.csv"));
        out.println(CSV.header("Method", "IterScale", "Repeat", "Metric", "Value", "TreeName"));
        List<File> files = IO.ls(InferenceExperiments.generator.output, "msf");
        for (File f : files) {
            data = f;
            String treeName = f.getName();
            LogInfo.track("Current tree:" + treeName);
            UnrootedTree goldut = InferenceExperiments.generator.useGutellData ? null : UnrootedTree.fromRooted(RootedTree.Util.fromNewickString(IO.f2s(new File(f.getAbsolutePath().replaceAll("[.]msf$", ".newick")))));
            File computedRefTrees = new File(Execution.getFile("computed-ref-trees"));
            File inferredTrees = new File(Execution.getFile("inferred-trees"));
            inferredTrees.mkdir();
            for (int i = 0; i < this.methods.size(); ++i) {
                InferenceMethod m = this.methods.get(i);
                double iterScale = this.iterScalings.get(i);
                LogInfo.track("Current method:" + (Object)((Object)m) + " with iterScale=" + iterScale + " (i.e. " + iterScale * this.nThousandIters * 1000.0 + " iterations)");
                StatisticsMap.DescriptiveStatisticsMap<String> stats = new StatisticsMap.DescriptiveStatisticsMap<String>();
                for (int j = 0; j < this.repPerDataPt; ++j) {
                    LogInfo.track("Repeat " + (j + 1) + "/" + this.repPerDataPt);
                    TreeDistancesProcessor processor = m.doIt(this, iterScale);
                    LogInfo.forceSilent = false;
                    UnrootedTree inferred = processor.getConsensus();
                    String str = "method" + (Object)((Object)m) + ".iterscale" + iterScale + ".treename" + treeName + ".repeat" + j;
                    File infCurrent = new File(inferredTrees, "inferredTree_" + str + ".newick");
                    IO.writeToDisk(infCurrent, inferred.toNewick());
                    Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                    CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                    UnrootedTreeState ncs = UnrootedTreeState.initFastState(inferred, dataset, (CTMC)ctmc);
                    out.println(CSV.body(new Object[]{m, iterScale, j, "ConsensusLogLL", ncs.logLikelihood(), treeName}));
                    double bestLogLL = processor.getBestLogLikelihood();
                    out.println(CSV.body(new Object[]{m, iterScale, j, "BestSampledLogLL", bestLogLL, treeName}));
                    if (goldut == null && this.refMethod != null) {
                        LogInfo.logsForce("Computing gold tree using " + (Object)((Object)this.refMethod));
                        goldut = this.refMethod.doIt(this, this.refIterScaling).getConsensus();
                        computedRefTrees.mkdir();
                        File current = new File(computedRefTrees, "computedRefTree_" + f.getName().replaceAll("[.]msf", "") + ".newick");
                        IO.writeToDisk(current, goldut.toNewick());
                    }
                    if (goldut != null) {
                        for (TreeEvaluator.TreeMetric tm : TreeEvaluator.coreTreeMetrics) {
                            double value = tm.score(inferred, goldut);
                            stats.addValue(tm.toString(), value);
                            out.println(CSV.body(new Object[]{m, iterScale, j, tm, value, treeName}));
                        }
                    }
                    LogInfo.end_track();
                }
                LogInfo.track("Score for current block of repeats (Method=" + (Object)((Object)m) + ",IterScale=" + iterScale + ",TreeName=" + treeName + ")");
                for (TreeEvaluator.TreeMetric tm : TreeEvaluator.coreTreeMetrics) {
                    LogInfo.logsForce("Current " + tm + ":" + stats.median(tm.toString()));
                }
                LogInfo.end_track();
                out.flush();
                LogInfo.end_track();
            }
            LogInfo.end_track();
        }
        out.close();
    }

    public static <T> double dist(Counter<T> c1, Counter<T> c2) {
        double sum = 0.0;
        for (Object t : CollUtils.union(c1.keySet(), c2.keySet())) {
            sum += Math.abs(c1.getCount(t) - c2.getCount(t));
        }
        return sum;
    }

    public static double dist(TreeDistancesProcessor p1, TreeDistancesProcessor p2) {
        return InferenceExperiments.dist(p1.getUnrootedCladesPosterior(), p2.getUnrootedCladesPosterior());
    }

    @Override
    public void run() {
        if (this.methods.size() != this.iterScalings.size()) {
            throw new RuntimeException("Number of methods and scaling iters should match");
        }
        LogInfo.logsForce("Generating data...");
        LogInfo.forceSilent = false;
        generator.run();
        LogInfo.forceSilent = false;
        this.output = new File(Execution.getFile("results"));
        this.output.mkdir();
        this.comparisonType.performComparison(this);
    }

    private void postComparison() {
        int i;
        data = new File(InferenceExperiments.generator.output, "sim-0.msf");
        HashMap results = CollUtils.map();
        for (int i2 = 0; i2 < this.methods.size(); ++i2) {
            InferenceMethod m = this.methods.get(i2);
            double iterScale = this.iterScalings.get(i2);
            results.put("Run" + i2 + "(" + m + "-" + iterScale + ")", m.doIt(this, iterScale));
        }
        File trees = new File(this.output, "trees");
        trees.mkdir();
        LogInfo.track("Trees");
        for (String key : results.keySet()) {
            UnrootedTree tree = ((TreeDistancesProcessor)results.get(key)).getConsensus();
            LogInfo.logsForce("" + key + ":\n" + tree);
            IO.writeToDisk(new File(trees, key + ".tree"), tree.toString());
            IO.writeToDisk(new File(trees, key + ".newick"), tree.toNewick());
        }
        LogInfo.end_track();
        ArrayList orderedResults = CollUtils.list(results.keySet());
        Table t = new Table();
        PrintWriter out = IOUtils.openOutEasy(new File(this.output, "distances.csv"));
        for (i = 0; i < orderedResults.size(); ++i) {
            t.set(0, i + 1, "" + (String)orderedResults.get(i));
            t.set(i + 1, 0, "" + (String)orderedResults.get(i));
        }
        for (i = 0; i < orderedResults.size(); ++i) {
            for (int j = 0; j < orderedResults.size(); ++j) {
                String key1 = (String)orderedResults.get(i);
                String key2 = (String)orderedResults.get(j);
                double dist = InferenceExperiments.dist((TreeDistancesProcessor)results.get(key1), (TreeDistancesProcessor)results.get(key2));
                t.set(i + 1, j + 1, dist);
                out.println(CSV.body(key1, key2, dist));
            }
        }
        IO.writeToDisk(new File(this.output, "dist-mtx"), t.toString());
        LogInfo.logsForce("Distances:\n" + t);
        out.close();
    }

    public static interface SMCInferenceSystem {
        public void doInference(File var1, SequenceType var2);

        public double[] getWeights();

        public List<UnrootedTree> getTrees();

        public void setN(int var1);

        public void setRand(Random var1);
    }

    public static enum InferenceMethod {
        MCMC{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                PhyloSampler._defaultPhyloSamplerOptions.rand = instance.mainRand;
                InferenceExperiments.samplerMain.alignmentInputFile = data;
                InferenceExperiments.samplerMain.st = SequenceType.RNA;
                PhyloSampler._defaultPhyloSamplerOptions.nIteration = (int)(iterScale * instance.nThousandIters * 1000.0);
                samplerMain.run();
                return InferenceExperiments.samplerMain.tdp;
            }
        }
        ,
        SMC_NJ{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                ParticleFilter<NJPState> pc = new ParticleFilter<NJPState>();
                pc.N = (int)(iterScale * instance.nThousandIters * 1000.0);
                if (instance.nThreads != 1) {
                    throw new RuntimeException();
                }
                pc.nThreads = instance.nThreads;
                pc.resampleLastRound = false;
                pc.rand = instance.mainRand;
                pc.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initState(dataset, ctmc);
                NJPState initNJP = NJPState.init(init);
                NJStateKernel kernel = new NJStateKernel(initNJP);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                pc.sample(kernel, tdp);
                return tdp;
            }
        }
        ,
        SMC{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                ParticleFilter<PartialCoalescentState> pc = new ParticleFilter<PartialCoalescentState>();
                pc.N = (int)(iterScale * instance.nThousandIters * 1000.0);
                pc.nThreads = instance.nThreads;
                pc.resampleLastRound = true;
                pc.rand = instance.mainRand;
                pc.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                TestBrownianModel.KernelType kernelType = TestBrownianModel.KernelType.PRIOR_PRIOR;
                if (instance.usePriorPost) {
                    kernelType = TestBrownianModel.KernelType.PRIOR_POST2;
                }
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState(dataset, ctmc);
                ParticleKernel<PartialCoalescentState> ppk = kernelType.load(init, null);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                pc.sample(ppk, tdp);
                LogInfo.logsForce("Norm:" + pc.estimateNormalizer());
                return tdp;
            }
        }
        ,
        SMC2{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                if (instance.usePriorPost) {
                    throw new RuntimeException();
                }
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = (int)(iterScale * instance.nThousandIters * 1000.0);
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = instance.mainRand;
                options.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState(dataset, ctmc);
                PriorPriorKernel pk2 = new PriorPriorKernel(init);
                LazyParticleFilter<PartialCoalescentState> lpf = new LazyParticleFilter<PartialCoalescentState>(pk2, options);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                double zHat = lpf.sample(tdp);
                return tdp;
            }
        }
        ,
        SMC2NC{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                if (instance.usePriorPost) {
                    throw new RuntimeException();
                }
                LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
                options.nParticles = (int)(iterScale * instance.nThousandIters * 1000.0);
                options.nThreads = instance.nThreads;
                options.resampleLastRound = true;
                options.parallelizeFinalParticleProcessing = true;
                options.finalMaxNUniqueParticles = instance.finalMaxNUniqueParticles;
                options.maxNUniqueParticles = instance.maxNUniqueParticles;
                options.rand = instance.mainRand;
                options.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState(instance.resampleRoot, dataset, ctmc, false);
                NCPriorPriorKernel pk2 = new NCPriorPriorKernel(init);
                LazyParticleFilter<PartialCoalescentState> lpf = new LazyParticleFilter<PartialCoalescentState>(pk2, options);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                double zHat = lpf.sample(tdp);
                return tdp;
            }
        }
        ,
        NCPF{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                ParticleFilter<PartialCoalescentState> pc = new ParticleFilter<PartialCoalescentState>();
                pc.N = (int)(iterScale * instance.nThousandIters * 1000.0);
                pc.nThreads = instance.nThreads;
                pc.resampleLastRound = true;
                pc.rand = instance.mainRand;
                pc.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState(instance.resampleRoot, dataset, ctmc, false);
                NCPriorPriorKernel ppk = new NCPriorPriorKernel(init);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                pc.sample(ppk, tdp);
                return tdp;
            }
        }
        ,
        PG{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                ParticleFilter<PartialCoalescentState> pc = new ParticleFilter<PartialCoalescentState>();
                pc.nThreads = instance.nThreads;
                pc.resampleLastRound = false;
                pc.rand = instance.mainRand;
                pc.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState(instance.resampleRoot, dataset, ctmc, false);
                NCPriorPriorKernel ppk = new NCPriorPriorKernel(init);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                double requested = iterScale * instance.nThousandIters * 1000.0;
                pc.N = 1 + (int)Math.pow(requested, instance.pmcmcSMCExpMix);
                PG pg = new PG(pc, ppk, tdp, init);
                int nMCMC = 1 + (int)Math.pow(requested, 1.0 - instance.pmcmcSMCExpMix);
                for (int i = 0; i < nMCMC; ++i) {
                    pg.next(instance.mainRand);
                }
                return tdp;
            }
        }
        ,
        PMCMC{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                ParticleFilter<PartialCoalescentState> pc = new ParticleFilter<PartialCoalescentState>();
                pc.nThreads = instance.nThreads;
                pc.resampleLastRound = false;
                pc.rand = instance.mainRand;
                pc.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState(instance.resampleRoot, dataset, ctmc, false);
                NCPriorPriorCondKernel ppk = new NCPriorPriorCondKernel(init);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                double requested = iterScale * instance.nThousandIters * 1000.0;
                pc.N = 1 + (int)Math.pow(requested, instance.pmcmcSMCExpMix);
                PMCMC pmcmc = new PMCMC(pc, ppk, tdp);
                int nMCMC = 1 + (int)Math.pow(requested, 1.0 - instance.pmcmcSMCExpMix);
                for (int i = 0; i < nMCMC; ++i) {
                    pmcmc.next(instance.mainRand);
                }
                return tdp;
            }
        }
        ,
        LAZYSMC{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                if (instance.nThreads > 1) {
                    throw new RuntimeException();
                }
                ParticleFilter<LazyPCS> pc = new ParticleFilter<LazyPCS>();
                pc.N = (int)(iterScale * instance.nThousandIters * 1000.0);
                pc.nThreads = instance.nThreads;
                pc.resampleLastRound = true;
                pc.resamplingStrategy = instance.resamplingStrategy;
                if (instance.useSimple) {
                    pc.resampleLastRound = false;
                }
                pc.rand = instance.mainRand;
                pc.verbose = instance.verbose;
                Dataset dataset = Dataset.DatasetUtils.fromAlignment(data, SequenceType.RNA);
                CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
                PartialCoalescentState init = PartialCoalescentState.initFastState(instance.resampleRoot, dataset, ctmc);
                LazyPriorPrior ppk = new LazyPriorPrior(init);
                if (instance.useSimple) {
                    ParticleFilter.StoreProcessor sp = new ParticleFilter.StoreProcessor();
                    pc.sample(ppk, sp);
                    PrintWriter out = IOUtils.openOutHard(Execution.getFile("particles-dump.txt"));
                    for (int i = 0; i < sp.ws.size(); ++i) {
                        LazyPCS lpcs = (LazyPCS)sp.particles.get(i);
                        PartialCoalescentState pcs = lpcs.getState();
                        RootedTree rt = pcs.getFullCoalescentState();
                        out.println("" + sp.ws.get(i) + "\t" + RootedTree.Util.toNewick(rt));
                    }
                    out.close();
                    Execution.finish();
                    return null;
                }
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                pc.sample(ppk, tdp);
                return tdp;
            }
        }
        ,
        MB{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                MrBayes mb = MrBayes.instance;
                mb.seed = instance.mainRand.nextInt();
                mb.nMCMCIters = (int)(iterScale * instance.nThousandIters * 1000.0);
                mb.computeSamples(MSAParser.parseMSA(data), SequenceType.RNA);
                TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                mb.processMrBayesTrees(tdp, 1);
                mb.cleanUpMrBayesOutput();
                return tdp;
            }
        }
        ,
        NJ{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                NJ nj = new NJ();
                MSAPoset align = MSAParser.parseMSA(data);
                RootedTree rt = nj.inferTree(align.toMultiAlignmentObject());
                final UnrootedTree urt = UnrootedTree.fromRooted(rt);
                return new TreeDistancesProcessor(){

                    @Override
                    public UnrootedTree getConsensus() {
                        return urt;
                    }
                };
            }
        }
        ,
        NINJA{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                MSAPoset align = MSAParser.parseMSA(data);
                final UnrootedTree tree = null;
                return new TreeDistancesProcessor(){

                    @Override
                    public UnrootedTree getConsensus() {
                        return tree;
                    }
                };
            }
        }
        ,
        NINJA2{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                MSAPoset align = MSAParser.parseMSA(data);
                final UnrootedTree tree = null;
                return new TreeDistancesProcessor(){

                    @Override
                    public UnrootedTree getConsensus() {
                        return tree;
                    }
                };
            }
        }
        ,
        LOAD{

            @Override
            public TreeDistancesProcessor doIt(InferenceExperiments instance, double iterScale) {
                try {
                    ClassLoader classLoader = SMCInferenceSystem.class.getClassLoader();
                    Class<?> aClass = classLoader.loadClass(instance.classToLoad);
                    SMCInferenceSystem inferenceSystem = (SMCInferenceSystem)aClass.newInstance();
                    inferenceSystem.setN((int)(iterScale * instance.nThousandIters * 1000.0));
                    inferenceSystem.setRand(instance.mainRand);
                    inferenceSystem.doInference(data, SequenceType.RNA);
                    TreeDistancesProcessor tdp = new TreeDistancesProcessor();
                    double[] ws = inferenceSystem.getWeights();
                    List<UnrootedTree> trees = inferenceSystem.getTrees();
                    if (ws.length != trees.size()) {
                        throw new RuntimeException();
                    }
                    for (int i = 0; i < ws.length; ++i) {
                        tdp.process(trees.get(i), ws[i]);
                    }
                    return tdp;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };


        abstract TreeDistancesProcessor doIt(InferenceExperiments var1, double var2);
    }

    public static enum ComparisonType {
        POST{

            @Override
            public void performComparison(InferenceExperiments instance) {
                instance.postComparison();
            }
        }
        ,
        TREE{

            @Override
            public void performComparison(InferenceExperiments instance) {
                instance.treeComparison();
            }
        };


        abstract void performComparison(InferenceExperiments var1);
    }
}

