/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multihmm;

import fenchel.algo.FactorGraphInferenceAlgorithm;
import fenchel.factor.FactorGraph;
import fenchel.factor.UnaryFactor;
import fenchel.factor.multihmm.MultiInputHMM;
import fenchel.factor.multihmm.MultiInputHMMComputations;
import fenchel.factor.multisites.MSUnaryMap;
import fenchel.factor.multisites.MSUnaryScaledFactor;
import fenchel.measurefacto.ExtendedExponentialFamily;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MultiInputHMMExpFam<N>
implements ExtendedExponentialFamily<MSUnaryMap<N>> {
    private final List<N> inputAddresses;
    private final MultiInputHMM hmm;
    private final boolean useOverComplete;
    FactorGraphInferenceAlgorithm<N> algo = null;

    public MultiInputHMMExpFam(List<N> inputAddresses, MultiInputHMM hmm, boolean useOverComplete) {
        this.inputAddresses = inputAddresses;
        this.hmm = hmm;
        this.useOverComplete = useOverComplete;
    }

    private List<double[][]> castInput(MSUnaryMap<N> input) {
        ArrayList<double[][]> result = new ArrayList<double[][]>();
        for (N n : this.inputAddresses) {
            result.add(input.getUnaryArray(n));
        }
        return result;
    }

    @Override
    public MSUnaryMap<N> moments(MSUnaryMap<N> input) {
        if (!this.useOverComplete) {
            input.setLastStatesToOne();
        }
        List<MSUnaryScaledFactor> result = MultiInputHMMComputations.computeMoments(this.castInput(input), this.hmm);
        final HashMap<N, MSUnaryScaledFactor> factorsMap = new HashMap<N, MSUnaryScaledFactor>();
        for (int i = 0; i < this.inputAddresses.size(); ++i) {
            factorsMap.put(this.inputAddresses.get(i), result.get(i));
        }
        this.algo = new FactorGraphInferenceAlgorithm<N>(){

            @Override
            public void init(FactorGraph<N> factorGraph) {
                throw new RuntimeException();
            }

            @Override
            public UnaryFactor moment(N node) {
                return (UnaryFactor)factorsMap.get(node);
            }

            @Override
            public double logZ() {
                throw new RuntimeException();
            }
        };
        return MSUnaryMap.fromMoments(this.algo, this.inputAddresses, !this.useOverComplete);
    }

    @Override
    public MSUnaryMap<N> getExtendedStatistics() {
        return MSUnaryMap.fromMoments(this.algo, this.inputAddresses, false);
    }
}

