/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisitecat;

import fenchel.factor.UnaryFactor;
import fenchel.factor.multisitecat.LowLevelOperations;
import java.util.Collections;
import java.util.List;
import nuts.util.CollUtils;

public class MSCUnaryScaledFactor
implements UnaryFactor {
    private double[] data;
    private double logNorm = 0.0;
    public final int nCategories;
    public final int nSites;
    public final int nCharacters;
    private boolean normalized = false;

    public void set(int site, int category, int character, double value) {
        if (site >= this.nSites || category >= this.nCategories || character >= this.nCharacters) {
            throw new RuntimeException();
        }
        this.data[LowLevelOperations.unaryIdx((int)site, (int)category, (int)character, (int)this.nCategories, (int)this.nCharacters)] = value;
    }

    public double get(int site, int category, int character) {
        this.ensureNormalized();
        return this.data[LowLevelOperations.unaryIdx(site, category, character, this.nCategories, this.nCharacters)];
    }

    public MSCUnaryScaledFactor(int nSites, int nCategories, int nCharacters) {
        this.nCategories = nCategories;
        this.nSites = nSites;
        this.nCharacters = nCharacters;
        this.data = new double[nSites * nCategories * nCharacters];
    }

    @Override
    public UnaryFactor multiply(List<UnaryFactor> otherFactors) {
        otherFactors = CollUtils.list(otherFactors);
        otherFactors.add(this);
        MSCUnaryScaledFactor result = new MSCUnaryScaledFactor(this.nSites, this.nCategories, this.nCharacters);
        int nFactors = otherFactors.size();
        double[][] unaries = new double[nFactors][];
        double[] unaryLogNorms = new double[nFactors];
        for (int f = 0; f < otherFactors.size(); ++f) {
            MSCUnaryScaledFactor current = (MSCUnaryScaledFactor)otherFactors.get(f);
            unaries[f] = current.data;
            unaryLogNorms[f] = current.logNorm;
        }
        result.logNorm = LowLevelOperations.pointwiseMultiply(unaries, unaryLogNorms, this.nSites, this.nCategories, this.nCharacters, result.data);
        result.normalized = true;
        return result;
    }

    @Override
    public double logNorm() {
        this.ensureNormalized();
        return this.logNorm;
    }

    public void ensureNormalized() {
        if (!this.normalized) {
            MSCUnaryScaledFactor temp = (MSCUnaryScaledFactor)this.multiply(Collections.EMPTY_LIST);
            this.data = temp.data;
            this.logNorm = temp.logNorm;
            this.normalized = true;
        }
    }

    public double[] _rawData() {
        return this.data;
    }

    double _rawLogNorm() {
        return this.logNorm;
    }

    void _setNorm(double newNorm) {
        this.logNorm = newNorm;
        this.normalized = true;
    }
}

