/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisites;

import fenchel.factor.multihmm.MultiInputHMM;
import fenchel.factor.multihmm.MultiInputHMMExpFam;
import fenchel.factor.multisites.MSFactorGraph;
import fenchel.factor.multisites.MSMFOptions;
import fenchel.factor.multisites.MSPointwiseOperatedApplicator;
import fenchel.factor.multisites.MSUnaryMap;
import fenchel.factor.multisites.SingleNodeHMMs;
import fenchel.factor.multisites.SubGraphExponentialFamily;
import fenchel.measurefacto.ExponentialFamily;
import fenchel.measurefacto.MFBeliefProp;
import fenchel.measurefacto.PointwiseOperationApplicator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nuts.math.Graph;

public class MSMeasureFacto<N> {
    private final Set<N> richNodesSet = new HashSet<N>();
    private final Set<N> querySet;
    private final MSFactorGraph<N> fullFactorGraph;
    private final List<ExponentialFamily<MSUnaryMap<N>>> approximations = new ArrayList<ExponentialFamily<MSUnaryMap<N>>>();
    private final List<Double> alphas = new ArrayList<Double>();
    private final MSMFOptions options;

    public void addTreeCoverFactors(Collection<Graph<N>> subGraphs, Set<N> richNodes, double alpha) {
        this.richNodesSet.addAll(richNodes);
        for (Graph<N> subGraph : subGraphs) {
            SubGraphExponentialFamily<N> treeApprox = new SubGraphExponentialFamily<N>(this.fullFactorGraph, subGraph, this.richNodesSet, this.querySet, this.options.useOverComplete);
            this.approximations.add(treeApprox);
            this.alphas.add(alpha);
        }
    }

    public void addSingleNodeHMMs(Set<N> nodes, double[][] trans, double alpha) {
        double[] init = new double[trans.length];
        Arrays.fill(init, 1.0 / (double)trans.length);
        this.addSingleNodeHMMs(nodes, init, trans, alpha);
    }

    public void addSingleNodeHMMs(Set<N> nodes, double[] init, double[][] trans, double alpha) {
        this.alphas.add(alpha);
        this.richNodesSet.addAll(nodes);
        this.approximations.add(new SingleNodeHMMs<N>(nodes, init, trans, this.options.useOverComplete));
    }

    public void addPhenotypeHMM(List<N> inputAddresses, MultiInputHMM hmm, double alpha) {
        this.alphas.add(alpha);
        this.richNodesSet.addAll(inputAddresses);
        this.approximations.add(new MultiInputHMMExpFam<N>(inputAddresses, hmm, this.options.useOverComplete));
    }

    public MSMeasureFacto(Set<N> querySet, MSFactorGraph<N> fullFactorGraph, MSMFOptions options) {
        this.options = options;
        this.querySet = querySet;
        this.fullFactorGraph = fullFactorGraph;
    }

    public MFBeliefProp<MSUnaryMap<N>> getMFBP() {
        if (this.approximations.size() != this.alphas.size()) {
            throw new RuntimeException();
        }
        MSUnaryMap<N> param = this.getParameters();
        return new MFBeliefProp<MSUnaryMap<N>>(param, this.getEmptyVector(), this.approximations, this.getApplicator(), this.alphas, this.options.correction, this.options.useSum);
    }

    private PointwiseOperationApplicator<MSUnaryMap<N>> getApplicator() {
        return new MSPointwiseOperatedApplicator();
    }

    private MSUnaryMap<N> getEmptyVector() {
        HashSet<N> alls = new HashSet<N>();
        alls.addAll(this.querySet);
        alls.addAll(this.richNodesSet);
        return MSUnaryMap.emptyCopy(this.fullFactorGraph, alls, false);
    }

    public MSUnaryMap<N> getParameters() {
        return MSUnaryMap.fromMSFactorGraphUnaryParameters(this.fullFactorGraph, this.richNodesSet, !this.options.useOverComplete);
    }
}

