/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.remote;

import fig.basic.LogInfo;
import fig.basic.SysInfoUtils;
import fig.exec.remote.BacklogEnhancedSocketFactory;
import fig.exec.remote.CustomClassLoader;
import fig.exec.remote.RemoteExecutorService;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RemoteExecutorImpl
implements RemoteExecutorService {
    private static RemoteExecutorService exec = null;
    public static final String RMI_NAME = "RMI_WORKER";
    ExecutorService threadExec;
    private static boolean machineRunningRmiJob = false;

    public static void startRmi(int rmiPort) {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            exec = new RemoteExecutorImpl();
            RMISocketFactory.setSocketFactory(new BacklogEnhancedSocketFactory());
            Registry registry = null;
            try {
                System.setProperty("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
                System.setProperty("java.naming.provider.url", "rmi://localhost:" + rmiPort);
                registry = LocateRegistry.createRegistry(rmiPort);
                LogInfo.logss("[WORKER] Starting RMI registry on " + SysInfoUtils.getHostName() + " on port " + rmiPort);
            }
            catch (RemoteException e) {
                LogInfo.logss("[WORKER] Could not start  RMI registry on " + SysInfoUtils.getHostName());
            }
            if (registry != null) {
                Remote exportObject = UnicastRemoteObject.exportObject((Remote)exec, 0);
                RemoteExecutorService stub = (RemoteExecutorService)exportObject;
                registry.rebind(RMI_NAME, stub);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean initialize(String codebase) {
        this.threadExec = Executors.newFixedThreadPool(1);
        CustomClassLoader.setExternalCodeBase(codebase);
        return !RemoteExecutorImpl.isMachineRunningRmiJob();
    }

    @Override
    public boolean remoteAwaitTermination(long arg0, TimeUnit arg1) throws InterruptedException, RemoteException {
        return this.threadExec.awaitTermination(arg0, arg1);
    }

    @Override
    public <T> List<Future<T>> remoteInvokeAll(Collection<Callable<T>> arg0) throws InterruptedException, RemoteException {
        return this.threadExec.invokeAll(arg0);
    }

    @Override
    public <T> List<Future<T>> remoteInvokeAll(Collection<Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, RemoteException {
        return this.threadExec.invokeAll(arg0, arg1, arg2);
    }

    @Override
    public void remoteExecute(Runnable arg0) throws RemoteException {
        this.threadExec.execute(arg0);
    }

    @Override
    public <T> T remoteInvokeAny(Collection<Callable<T>> arg0) throws InterruptedException, ExecutionException, RemoteException {
        return this.threadExec.invokeAny(arg0);
    }

    @Override
    public <T> T remoteInvokeAny(Collection<Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, ExecutionException, TimeoutException, RemoteException {
        return this.threadExec.invokeAny(arg0, arg1, arg2);
    }

    @Override
    public boolean remoteIsShutdown() throws RemoteException {
        return this.threadExec.isShutdown();
    }

    @Override
    public List<Runnable> remoteShutdownNow() throws RemoteException {
        return this.threadExec.shutdownNow();
    }

    @Override
    public <T> T remoteSubmit(Callable<T> arg0) throws RemoteException {
        RemoteExecutorImpl.setMachineRunningRmiJob(true);
        Future<T> future = this.threadExec.submit(arg0);
        try {
            T t = future.get();
            RemoteExecutorImpl.setMachineRunningRmiJob(true);
            return t;
        }
        catch (Exception e) {
            RemoteExecutorImpl.setMachineRunningRmiJob(true);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<?> remoteSubmit(Runnable arg0) throws RemoteException {
        return this.threadExec.submit(arg0);
    }

    @Override
    public <T> Future<T> remoteSubmit(Runnable arg0, T arg1) throws RemoteException {
        return this.threadExec.submit(arg0, arg1);
    }

    @Override
    public boolean remoteIsTerminated() throws RemoteException {
        return this.threadExec.isTerminated();
    }

    @Override
    public void remoteShutdown() throws RemoteException {
        this.threadExec.shutdown();
    }

    public static synchronized boolean isMachineRunningRmiJob() {
        return machineRunningRmiJob;
    }

    public static synchronized void setMachineRunningRmiJob(boolean machineRunningRmiJob) {
        RemoteExecutorImpl.machineRunningRmiJob = machineRunningRmiJob;
    }
}

