/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.OrderedStringMap;
import fig.exec.servlet.BasketDB;
import fig.exec.servlet.BasketFactory;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.ExecFactory;
import fig.exec.servlet.ExecViewDB;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FieldsSpec;
import fig.exec.servlet.FileFactory;
import fig.exec.servlet.FileViewDB;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.Value;
import fig.exec.servlet.View;
import fig.exec.servlet.WebState;
import java.io.File;
import java.io.IOException;

public class DomainView
extends View<View> {
    private String path;
    private FileFactory fileFactory;
    private ExecFactory execFactory;
    private BasketFactory basketFactory;
    private String rootDir;
    private String title;
    private boolean isHidden;
    private FileViewDB fileViewDB;
    private BasketDB basketDB;
    private ExecViewDB execViewDB;

    public void loadSpec() {
        FieldsSpec fieldsSpec = new FieldsSpec(this.path);
        OrderedStringMap map = null;
        try {
            map = OrderedStringMap.fromFile(this.path);
        }
        catch (IOException e) {
            WebState.logs("DomainView: error loading " + this.path);
        }
        WebState.logs(this.path);
        this.title = (String)map.get("title");
        this.rootDir = (String)map.get("rootDir");
        this.isHidden = map.containsKey("isHidden");
        try {
            if (this.fileFactory == null) {
                FileFactory fileFactory = this.fileFactory = map.containsKey("fileFactory") ? (FileFactory)Class.forName((String)map.get("fileFactory")).newInstance() : new FileFactory();
            }
            if (this.execFactory == null) {
                ExecFactory execFactory = this.execFactory = map.containsKey("execFactory") ? (ExecFactory)Class.forName((String)map.get("execFactory")).newInstance() : new ExecFactory();
            }
            if (this.basketFactory == null) {
                this.basketFactory = map.containsKey("basketFactory") ? (BasketFactory)Class.forName((String)map.get("basketFactory")).newInstance() : new BasketFactory();
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.execFactory.setFieldsSpec(fieldsSpec);
    }

    public DomainView(Trail trail, String path) {
        if (trail == null) {
            return;
        }
        this.trail = trail;
        this.path = path;
        this.loadSpec();
        this.fileViewDB = new FileViewDB(this.childTrail("files"), this.fileFactory, this);
        this.execViewDB = new ExecViewDB(this.childTrail("execs"), new DirSource(this, new File(this.rootDir, "execs").toString()), new DirSource(this, new File(this.rootDir, "views").toString()), this.execFactory);
        this.basketDB = new BasketDB(this.childTrail("baskets"), new DirSource(this, new File(this.rootDir, "baskets").toString()), this.basketFactory);
        this.addItemHard(this.fileViewDB);
        this.addItemHard(this.execViewDB);
        this.addItemHard(this.basketDB);
    }

    @Override
    protected Value getFieldValue(String name) throws MyException {
        if (name.equals("title")) {
            return new Value(this.title);
        }
        if (name.equals("rootDir")) {
            return new Value(this.rootDir);
        }
        return super.getFieldValue(name);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add(new Field("title", "Title"));
        fields.add(new Field("rootDir", "Root directory"));
        return fields;
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.loadSpec();
    }

    @Override
    protected boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public FieldListMap getItemsFields() {
        return new FieldListMap();
    }

    public ExecViewDB getExecViewDB() {
        return this.execViewDB;
    }

    public FileViewDB getFileViewDB() {
        return this.fileViewDB;
    }

    public BasketDB getBasketDB() {
        return this.basketDB;
    }
}

