/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class OnlineRecordFilter
implements Runnable {
    @Option
    public static String inPath = "/dev/stdin";
    @Option
    public static String outPath = "/dev/stdout";
    @Option
    public ArrayList<String> filterPath = new ArrayList();
    @Option
    public int depth = Integer.MAX_VALUE;

    public boolean matches(String s, String key, String value) {
        String[] tokens = s.split("\t", 2);
        if (!(key == null || tokens.length >= 1 && key.equals(tokens[0]))) {
            return false;
        }
        return value == null || tokens.length >= 2 && value.equals(tokens[1]);
    }

    @Override
    public void run() {
        ArrayList<String> filterKeys = new ArrayList<String>();
        ArrayList<String> filterValues = new ArrayList<String>();
        for (String filter : this.filterPath) {
            int i = filter.indexOf(61);
            String key = null;
            String value = null;
            if (i == 0) {
                value = filter;
            } else if (i == -1) {
                key = filter;
            } else {
                key = filter.substring(0, i);
                value = filter.substring(i + 1);
            }
            filterKeys.add(key);
            filterValues.add(value);
        }
        try {
            String line;
            BufferedReader in = IOUtils.openIn(inPath);
            PrintWriter out = IOUtils.openOut(outPath);
            boolean prevIndent = false;
            int numMatch = 0;
            while ((line = in.readLine()) != null) {
                int indent;
                for (indent = 0; indent < line.length() && line.charAt(indent) == '\t'; ++indent) {
                }
                if (indent < numMatch) {
                    numMatch = indent;
                }
                if (numMatch == indent && numMatch < this.filterPath.size()) {
                    String key = (String)filterKeys.get(numMatch);
                    String value = (String)filterValues.get(numMatch);
                    if (this.matches(line.substring(indent), key, value)) {
                        ++numMatch;
                    }
                }
                if (numMatch != this.filterPath.size() || indent - numMatch >= this.depth) continue;
                out.println(numMatch == 0 ? line : line.substring(numMatch - 1));
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Execution.startMainTrack = false;
        Execution.run(args, new OnlineRecordFilter());
    }
}

