/*
 * Decompiled with CFR 0.152.
 */
package ma;

import goblin.DerivationTree;
import goblin.Taxon;
import java.util.List;
import java.util.Random;
import ma.AffineGapAlignmentSampler;
import ma.MultiAlignment;
import nuts.math.MeasureZeroException;
import nuts.util.Arbre;

public class ArbreInitializer {
    private final AffineGapAlignmentSampler.GapAlignmentParams params;
    private final Random rand;
    private MultiAlignment goldAlign;

    public ArbreInitializer(AffineGapAlignmentSampler.GapAlignmentParams params, Random rand) {
        this.params = params;
        this.rand = rand;
        this.goldAlign = null;
    }

    public ArbreInitializer(MultiAlignment goldAlign, Random rand) {
        this.params = null;
        this.rand = rand;
        this.goldAlign = goldAlign;
    }

    public boolean usesGoldAlign() {
        if (this.goldAlign != null && this.params != null) {
            throw new RuntimeException();
        }
        return this.goldAlign != null;
    }

    public Arbre<DerivationTree.DerivationNode> init(Arbre<DerivationTree.DerivationNode> tree) {
        Arbre<DerivationTree.DerivationNode> copy = tree.copy();
        this.recInit(copy);
        return copy;
    }

    private void recInit(Arbre<DerivationTree.DerivationNode> currentSubTree) {
        if (currentSubTree.isLeaf()) {
            return;
        }
        List<Arbre<DerivationTree.DerivationNode>> children = currentSubTree.getChildren();
        for (Arbre<DerivationTree.DerivationNode> child : children) {
            this.recInit(child);
        }
        if (children.size() != 2) {
            throw new RuntimeException("Tree should be binary for this type of initialization:\n" + currentSubTree.deepToString());
        }
        String child0 = children.get(0).getContents().getWord();
        String child1 = children.get(1).getContents().getWord();
        Taxon child0Lang = children.get(0).getContents().getLanguage();
        Taxon child1Lang = children.get(1).getContents().getLanguage();
        Taxon topLang = currentSubTree.getContents().getLanguage();
        MultiAlignment guideAlign = null;
        guideAlign = this.usesGoldAlign() ? (this.goldAlign = this.goldAlign.interpolate(child0Lang, child1Lang, topLang, this.rand)) : this.sampledDerivation(child0, child1, child0Lang, child1Lang).interpolate(child0Lang, child1Lang, topLang, this.rand);
        String topWord = guideAlign.getSequences().get(topLang);
        DerivationTree.DerivationNode topDN = new DerivationTree.DerivationNode(topLang, topWord);
        currentSubTree.setContents(topDN);
        DerivationTree.Derivation child0deriv = guideAlign.getDerivation(topLang, child0Lang);
        DerivationTree.Derivation child1deriv = guideAlign.getDerivation(topLang, child1Lang);
        children.get(0).setContents(new DerivationTree.DerivationNode(child0Lang, child0, child0deriv));
        children.get(1).setContents(new DerivationTree.DerivationNode(child1Lang, child1, child1deriv));
    }

    private MultiAlignment sampledDerivation(String child0, String child1, Taxon child0Lang, Taxon child1Lang) {
        AffineGapAlignmentSampler sampler = this.createSampler(child0, child1);
        DerivationTree.Derivation directDerivationFrom0To1 = null;
        try {
            directDerivationFrom0To1 = sampler.mode();
        }
        catch (MeasureZeroException mze) {
            throw new RuntimeException(mze);
        }
        return MultiAlignment.inducedMultiAlignment(child0Lang, child1Lang, directDerivationFrom0To1);
    }

    private AffineGapAlignmentSampler createSampler(String w1, String w2) {
        return AffineGapAlignmentSampler.createAffineGapAlignmentSampler(w1, w2, this.params);
    }
}

