/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import fig.basic.Pair;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class LexicographicComparator<T extends Comparable<T>>
implements Comparator<List<T>> {
    private boolean lengthFirst = false;
    private int comparisonLimit = Integer.MAX_VALUE;

    public static <S extends Comparable<S>> PairComparator<S> pairComparator() {
        return new PairComparator();
    }

    public LexicographicComparator(boolean lengthFirst) {
        this.lengthFirst = lengthFirst;
    }

    public static <K extends Comparable<K>> LexicographicComparator<K> newInstance() {
        return new LexicographicComparator();
    }

    public LexicographicComparator() {
        this.lengthFirst = false;
    }

    public void setComparisonLimit(int compLim) {
        this.comparisonLimit = compLim;
    }

    @Override
    public int compare(List<T> arg0, List<T> arg1) {
        return LexicographicComparator.lexCompare(arg0, arg1, this.lengthFirst, this.comparisonLimit);
    }

    public static <T extends Comparable<T>> int lexCompare(List<T> arg0, List<T> arg1) {
        return LexicographicComparator.lexCompare(arg0, arg1, false, Integer.MAX_VALUE);
    }

    public static <T extends Comparable<T>> int lexCompare(List<T> arg0, List<T> arg1, boolean lengthFirst, int comparisonLimit) {
        if (arg0 == null || arg1 == null) {
            throw new RuntimeException("Elements compared in LexicographicComparatorshould not be null");
        }
        arg0 = arg0.subList(0, Math.min(arg0.size(), comparisonLimit));
        arg1 = arg1.subList(0, Math.min(arg1.size(), comparisonLimit));
        if (lengthFirst) {
            if (arg0.size() > arg1.size()) {
                return 1;
            }
            if (arg0.size() < arg1.size()) {
                return -1;
            }
        }
        for (int i = 0; i < Math.min(arg0.size(), arg1.size()); ++i) {
            Comparable o1;
            Comparable o0 = (Comparable)arg0.get(i);
            int comp = o0.compareTo(o1 = (Comparable)arg1.get(i));
            if (comp < 0) {
                return -1;
            }
            if (comp <= 0) continue;
            return 1;
        }
        if (arg0.size() > arg1.size()) {
            return 1;
        }
        if (arg0.size() < arg1.size()) {
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        LexicographicComparator.test("a", "b");
        LexicographicComparator.test("k", "x");
        LexicographicComparator.test("alek", "alex");
        LexicographicComparator.test("aleksandre", "alexandre");
        LexicographicComparator.test("alex", "alexandre");
    }

    public static void test(String _one, String _two) {
        List<Character> two;
        LexicographicComparator<Character> comp = new LexicographicComparator<Character>(false);
        List<Character> one = LexicographicComparator.s2lc(_one);
        int compIndex = comp.compare(one, two = LexicographicComparator.s2lc(_two));
        if (compIndex < 0) {
            System.out.println(one + " < " + two);
        } else if (compIndex > 0) {
            System.out.println(one + " > " + two);
        } else {
            System.out.println(one + " == " + two);
        }
    }

    public static List<Character> s2lc(String word) {
        ArrayList<Character> current = new ArrayList<Character>();
        for (char letter : word.toCharArray()) {
            current.add(Character.valueOf(letter));
        }
        return current;
    }

    public static final class Pair2List<T>
    extends AbstractList<T> {
        private final Pair<T, T> pair;

        public Pair2List(Pair<T, T> pair) {
            this.pair = pair;
            throw new RuntimeException();
        }

        @Override
        public T get(int index) {
            if (index == 0) {
                return this.pair.getFirst();
            }
            if (index == 1) {
                return this.pair.getSecond();
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 2;
        }
    }

    public static class PairComparator<S extends Comparable<S>>
    implements Comparator<Pair<S, S>> {
        private LexicographicComparator<S> lc = new LexicographicComparator(false);

        @Override
        public int compare(Pair<S, S> arg0, Pair<S, S> arg1) {
            return this.lc.compare((List<S>)new Pair2List<S>(arg0), (List<S>)new Pair2List<S>(arg0));
        }
    }
}

