/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nuts.io.IO;

public class PhonemesFile
implements Iterable<Character> {
    private Map<Character, List<String>> entries = new HashMap<Character, List<String>>();
    private int numberOfPartitions = -1;

    public static PhonemesFile load(String path) throws IOException {
        PhonemesFile pf = new PhonemesFile();
        for (String line : IO.i(path)) {
            String[] fields = line.split("\\s+|\\t+");
            pf.numberOfPartitions = fields.length - 1;
            char currentCharacter = fields[0].charAt(0);
            ArrayList<String> classes = new ArrayList<String>();
            for (int i = 1; i < fields.length; ++i) {
                classes.add(fields[i]);
            }
            pf.entries.put(Character.valueOf(currentCharacter), classes);
        }
        return pf;
    }

    public String getField(char c, int indexInFile) {
        List<String> entry = this.entries.get(Character.valueOf(c));
        if (entry == null) {
            throw new RuntimeException("Entry not found for char " + c);
        }
        return entry.get(indexInFile).replaceAll("\\s+", "");
    }

    @Override
    public Iterator<Character> iterator() {
        return this.entries.keySet().iterator();
    }

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }
}

