/*
 * Decompiled with CFR 0.152.
 */
package ru;

import ev.GreedyCognateInference;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Parallelizer;
import fig.basic.UnorderedPair;
import fig.exec.Execution;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DataPrepUtils;
import goblin.DerivationTree;
import goblin.ObservationsTracker;
import goblin.Taxon;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.math.GMFct;
import nuts.math.Graph;
import nuts.math.MutableGraph;
import nuts.math.TabularGMFct;
import nuts.math.TreeSumProd;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.Indexer;
import ru.TreeLocation;

public final class PCPPrototype
implements Runnable {
    @Option(required=true)
    public String cognateFile;
    @Option
    public double soundChangePr = 0.9;
    @Option
    public double indelPot = 0.01;
    @Option
    public double subPot = 0.05;
    @Option
    public double selfSubPot = 1.0;
    @Option
    public double delDel = 1.0;
    @Option
    public int nThreads = 1;
    private CognateSet cognates = null;
    private Arbre<Taxon> globalTopo;
    private Map<Taxon, Taxon> parents;
    private Map<Taxon, List<SoundChange>> allSoundChanges = new HashMap<Taxon, List<SoundChange>>();
    private Map<CognateId, List<Site>> sites = new HashMap<CognateId, List<Site>>();
    private PhonemeEncodings p;
    private double[][] _backgrounProcess = null;

    private List<SoundChange> getSoundChanges(Taxon bottomOfEdge) {
        return CollUtils.getNoNullList(this.allSoundChanges, bottomOfEdge);
    }

    private Taxon parent(Taxon node) {
        return this.parents.get(node);
    }

    private void addSoundChange(SoundChange change, Taxon botLang, int index) {
        this.getSoundChanges(botLang).add(index, change);
    }

    private double backgroundProcess(int i, int j) {
        return this._backgrounProcess[i][j];
    }

    private double changeProcess(int topGlobalIndex, int botGlobalIndex, SoundChange change) {
        double result = 0.0;
        if (topGlobalIndex == botGlobalIndex) {
            result += 1.0 - this.soundChangePr;
        }
        if (botGlobalIndex == change.apply(topGlobalIndex)) {
            result += this.soundChangePr;
        }
        return result;
    }

    private void createBackgroundProcess() {
        this._backgrounProcess = new double[this.p.N][this.p.N];
        for (int i = 0; i < this.p.N; ++i) {
            for (int j = 0; j < this.p.N; ++j) {
                this._backgrounProcess[i][j] = i == this.p.CODE_GAP && j == this.p.CODE_GAP ? this.delDel : (i == j ? this.selfSubPot : (i != this.p.CODE_GAP && j != this.p.CODE_GAP ? this.subPot : this.indelPot));
            }
        }
    }

    public static void main(String[] args) {
        IO.run(args, new PCPPrototype());
    }

    @Override
    public void run() {
        try {
            this.cognates = CognateSet.restoreCognateSet(this.cognateFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.p = new PhonemeEncodings(this.cognates);
        this.createBackgroundProcess();
        final List<SoundChange> changes = PCPPrototype.allSimpleSoundChanges(this.p);
        LogInfo.logs("Number of sound changes: " + changes.size());
        LogInfo.logs("Sound changes: " + changes);
        this.globalTopo = GreedyCognateInference.unionTree(this.cognates);
        this.parents = Arbre.parents(this.globalTopo);
        LogInfo.logs(this.globalTopo.deepToString());
        for (CognateId id : this.cognates.getCognateIds()) {
            this.sites.put(id, this.toSites(id));
        }
        LogInfo.logs("Computing full fwd-bwd..");
        final Moments moments = new Moments();
        LogInfo.logs("Initial:" + moments.logLikelihood);
        Parallelizer<Arbre<Taxon>> parallelizer = new Parallelizer<Arbre<Taxon>>(this.nThreads);
        parallelizer.setPrimaryThread();
        parallelizer.process(this.globalTopo.nodes(), new Parallelizer.Processor<Arbre<Taxon>>(){

            @Override
            public void process(Arbre<Taxon> x, int _i, int _n, boolean log) {
                if (x.isRoot()) {
                    return;
                }
                LogInfo.logs("Processing " + x.getContents());
                Counter<String> c = new Counter<String>();
                for (SoundChange change : changes) {
                    c.setCount(change + "@" + x.getContents(), moments.peek(change, x.getContents(), 0));
                }
                PrintWriter out = IOUtils.openOutHard(Execution.getFile(x.getContents().toString()));
                for (String s : c) {
                    out.println(s + "\t" + c.getCount(s));
                }
                out.close();
            }
        });
    }

    private List<Site> toSites(CognateId id) {
        ArrayList<Site> result = new ArrayList<Site>();
        MultiAlignment msa = MultiAlignment.fullInducedMultiAlignment(this.cognates.getTree(id));
        MultiAlignment.LinearizedAlignmentMatrix lam = msa.createAlignmentMatrix();
        for (int col = 0; col < lam.nCols(); ++col) {
            result.add(this.toSite(lam, col, this.cognates.getObs(id)));
        }
        return result;
    }

    private Site toSite(MultiAlignment.LinearizedAlignmentMatrix lam, int col, ObservationsTracker obs) {
        HashMap<Taxon, Integer> valuesAtLeaves = new HashMap<Taxon, Integer>();
        Indexer<Integer> indexer = new Indexer<Integer>();
        indexer.addToIndex(this.p.CODE_GAP);
        for (int row = 0; row < lam.nRows(); ++row) {
            Taxon lang = lam.langAt(row);
            int currentGlobalIndex = this.p.index.o2i(Character.valueOf(lam.charAt(row, col)));
            if (!indexer.containsObject(currentGlobalIndex)) {
                indexer.addToIndex((Integer[])new Integer[]{currentGlobalIndex});
            }
            int currentLocalIndex = indexer.o2i(currentGlobalIndex);
            if (!obs.isObserved(lam.langAt(row))) continue;
            valuesAtLeaves.put(lang, currentLocalIndex);
        }
        return new Site(valuesAtLeaves, indexer);
    }

    private GraphicalModelTemplate getGMTemplate(CognateId id) {
        Arbre<DerivationTree.DerivationNode> t = this.cognates.getTree(id);
        return new GraphicalModelTemplate(DataPrepUtils.arbreDeriv2Lang(t));
    }

    public static List<SoundChange> allSimpleSoundChanges(PhonemeEncodings p) {
        Set<Character> allChars = p.index.objects();
        ArrayList<SoundChange> result = new ArrayList<SoundChange>();
        for (Character src : allChars) {
            for (Character dest : allChars) {
                if (src == dest || src.charValue() == '.' && dest.charValue() == '.') continue;
                result.add(new SimpleSoundChange(src.charValue(), dest.charValue(), p));
            }
        }
        return result;
    }

    public static CognateSet createSimpleCognateSet() {
        CognateSet result = new CognateSet();
        CognateId id = new CognateId("cog1");
        Taxon top = new Taxon("top");
        Taxon bot = new Taxon("bot");
        Taxon bot2 = new Taxon("bot2");
        String topW = "b.";
        String botW = "b.";
        String botW2 = "b.";
        ObservationsTracker track = new ObservationsTracker(Arrays.asList(bot, bot2));
        DerivationTree.DerivationNode topdn = new DerivationTree.DerivationNode(top, topW);
        DerivationTree.DerivationNode botdn = new DerivationTree.DerivationNode(bot, botW, new DerivationTree.Derivation(new int[]{0, 1}, topW, botW));
        DerivationTree.DerivationNode botdn2 = new DerivationTree.DerivationNode(bot2, botW2, new DerivationTree.Derivation(new int[]{0, 1}, topW, botW2));
        List children = Arrays.asList(Arbre.arbre(botdn), Arbre.arbre(botdn2));
        Arbre<DerivationTree.DerivationNode> a = Arbre.arbre(topdn, children);
        result.addCognate(id, a, track);
        return result;
    }

    public static final class SimpleSoundChange
    implements SoundChange {
        private final int src;
        private final int dest;
        private final PhonemeEncodings p;

        public SimpleSoundChange(char src, char dest, PhonemeEncodings p) {
            this.p = p;
            this.src = p.index(src);
            this.dest = p.index(dest);
        }

        @Override
        public int apply(int c) {
            if (c == this.src) {
                return this.dest;
            }
            return c;
        }

        public String toString() {
            return this.p.phone(this.src) + " > " + this.p.phone(this.dest);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dest;
            result = 31 * result + this.src;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleSoundChange other = (SimpleSoundChange)obj;
            if (this.dest != other.dest) {
                return false;
            }
            return this.src == other.src;
        }

        @Override
        public int compareTo(SoundChange _o) {
            SimpleSoundChange o = (SimpleSoundChange)_o;
            if (this.src != o.src) {
                return this.src - o.src;
            }
            return this.dest - o.dest;
        }
    }

    public static interface SoundChange
    extends Comparable<SoundChange> {
        public int apply(int var1);
    }

    private final class GraphicalModelTemplate {
        private final MutableGraph<TreeLocation> graph = new MutableGraph();

        public GMFct<TreeLocation> createGraphicalModel(final Site site) {
            final int varSize = site.siteIndexer.size();
            return new GMFct<TreeLocation>(){

                @Override
                public double get(TreeLocation tl1, TreeLocation tl2, int s1, int s2) {
                    if (tl1.isChangePoint() && tl2.isChangePoint() && tl1.localizedChange.equals(tl2.localizedChange)) {
                        SoundChange change = tl1.localizedChange;
                        int topGlobalIndex = site.local2global(tl1.isBottomEndPointOfChange != false ? s2 : s1);
                        int botGlobalIndex = site.local2global(tl1.isBottomEndPointOfChange != false ? s1 : s2);
                        return PCPPrototype.this.changeProcess(topGlobalIndex, botGlobalIndex, change);
                    }
                    return PCPPrototype.this.backgroundProcess(site.local2global(s1), site.local2global(s2));
                }

                @Override
                public double get(TreeLocation tl, int s) {
                    if (tl.isSpeciationPoint() && site.valueAtLeaves.keySet().contains(tl.speciationPoint)) {
                        return s == site.valueAtLeaves.get(tl.speciationPoint) ? 1.0 : 0.0;
                    }
                    return 1.0;
                }

                @Override
                public Graph<TreeLocation> graph() {
                    return GraphicalModelTemplate.this.graph;
                }

                @Override
                public int nStates(TreeLocation node) {
                    return varSize;
                }
            };
        }

        public GraphicalModelTemplate(Arbre<Taxon> arbre) {
            for (Arbre<Taxon> node : arbre.nodes()) {
                if (node.isRoot()) continue;
                this.processEdgesBetween(node.getContents(), node.getParent().getContents(), PCPPrototype.this.getSoundChanges(node.getContents()));
            }
        }

        private void processEdgesBetween(Taxon language, Taxon parent, List<SoundChange> changes) {
            TreeLocation prev = new TreeLocation(language);
            for (SoundChange change : changes) {
                TreeLocation bottomOfSoundChange = new TreeLocation(change, true);
                TreeLocation topOfSoundChange = new TreeLocation(change, false);
                this.graph.addEdge(new UnorderedPair<TreeLocation, TreeLocation>(prev, bottomOfSoundChange));
                this.graph.addEdge(new UnorderedPair<TreeLocation, TreeLocation>(topOfSoundChange, bottomOfSoundChange));
                prev = topOfSoundChange;
            }
            this.graph.addEdge(new UnorderedPair<TreeLocation, TreeLocation>(prev, new TreeLocation(parent)));
        }
    }

    public static final class Site {
        public final Map<Taxon, Integer> valueAtLeaves;
        public final Indexer<Integer> siteIndexer;

        public int local2global(int localIndex) {
            return this.siteIndexer.i2o(localIndex);
        }

        public int global2local(int globalIndex) {
            return this.siteIndexer.o2i(globalIndex);
        }

        public Site(Map<Taxon, Integer> valueAtLeaves, Indexer<Integer> indexer) {
            this.valueAtLeaves = valueAtLeaves;
            this.siteIndexer = indexer;
        }
    }

    public class Moments {
        private final Map<CognateId, List<GMFct<TreeLocation>>> moments = new HashMap<CognateId, List<GMFct<TreeLocation>>>();
        private double logLikelihood = 0.0;

        public Moments() {
            for (CognateId id : PCPPrototype.this.cognates.getCognateIds()) {
                GraphicalModelTemplate template = PCPPrototype.this.getGMTemplate(id);
                ArrayList<TabularGMFct<TreeLocation>> list = new ArrayList<TabularGMFct<TreeLocation>>();
                this.moments.put(id, list);
                for (Site site : (List)PCPPrototype.this.sites.get(id)) {
                    TreeSumProd<TreeLocation> tsp = new TreeSumProd<TreeLocation>(template.createGraphicalModel(site));
                    list.add(tsp.moments());
                    this.logLikelihood += tsp.logZ();
                }
            }
        }

        public double peek(SoundChange change, TreeLocation top, TreeLocation bot) {
            double correction = 0.0;
            for (CognateId id : PCPPrototype.this.cognates.getCognateIds()) {
                if (!this.hasBothBranches(this.moments.get(id).get(0).graph().vertexSet(), top, bot)) continue;
                List<GMFct<TreeLocation>> momentList = this.moments.get(id);
                List siteList = (List)PCPPrototype.this.sites.get(id);
                for (int siteIdx = 0; siteIdx < siteList.size(); ++siteIdx) {
                    GMFct<TreeLocation> currentMoment = momentList.get(siteIdx);
                    Site currentSite = (Site)siteList.get(siteIdx);
                    double[][] sumMiniBranch = this.computeSumMiniBranch(change, currentSite);
                    double sum = 0.0;
                    for (int topLocalIdx = 0; topLocalIdx < currentSite.siteIndexer.size(); ++topLocalIdx) {
                        int topGlobalIdx = currentSite.local2global(topLocalIdx);
                        for (int botLocalIdx = 0; botLocalIdx < currentSite.siteIndexer.size(); ++botLocalIdx) {
                            int botGlobalIdx = currentSite.local2global(botLocalIdx);
                            sum += currentMoment.get(top, bot, topLocalIdx, botLocalIdx) * sumMiniBranch[topLocalIdx][botLocalIdx] / PCPPrototype.this.backgroundProcess(topGlobalIdx, botGlobalIdx);
                        }
                    }
                    correction += Math.log(sum);
                }
            }
            return this.logLikelihood + correction;
        }

        public double peek(SoundChange change, Taxon branchBottom, int index) {
            List currentChangeList = PCPPrototype.this.getSoundChanges(branchBottom);
            TreeLocation bot = index == 0 ? new TreeLocation(branchBottom) : new TreeLocation((SoundChange)currentChangeList.get(index - 1), false);
            TreeLocation top = index == currentChangeList.size() ? new TreeLocation(PCPPrototype.this.parent(branchBottom)) : new TreeLocation((SoundChange)currentChangeList.get(index), true);
            return this.peek(change, top, bot);
        }

        private boolean hasBothBranches(Set<TreeLocation> vertexSet, TreeLocation top, TreeLocation bot) {
            if (!vertexSet.contains(top)) {
                return false;
            }
            return vertexSet.contains(bot);
        }

        private double[][] computeSumMiniBranch(SoundChange change, Site site) {
            double sum;
            int y;
            int N2 = site.siteIndexer.size();
            double[][] result = new double[N2][N2];
            double[][] interm = new double[N2][N2];
            for (int v = 0; v < N2; ++v) {
                for (y = 0; y < N2; ++y) {
                    sum = 0.0;
                    for (int w = 0; w < N2; ++w) {
                        sum += PCPPrototype.this.changeProcess(site.local2global(v), site.local2global(w), change) * PCPPrototype.this.backgroundProcess(site.local2global(w), site.local2global(y));
                    }
                    interm[v][y] = sum;
                }
            }
            for (int x = 0; x < N2; ++x) {
                for (y = 0; y < N2; ++y) {
                    sum = 0.0;
                    for (int v = 0; v < N2; ++v) {
                        sum += PCPPrototype.this.backgroundProcess(site.local2global(x), site.local2global(v)) * interm[v][y];
                    }
                    result[x][y] = sum;
                }
            }
            return result;
        }
    }

    public static class PhonemeEncodings {
        public static final char GAP = '.';
        public final int CODE_GAP;
        public final int N;
        public final Indexer<Character> index = new Indexer();

        public int index(char phoneme) {
            return this.index.o2i(Character.valueOf(phoneme));
        }

        public char phone(int idx) {
            return this.index.i2o(idx).charValue();
        }

        public PhonemeEncodings(CognateSet cs) {
            this.index.addToIndex((Character[])new Character[]{Character.valueOf('.')});
            this.CODE_GAP = this.index.o2i(Character.valueOf('.'));
            for (String word : cs.allWords()) {
                for (char c : word.toCharArray()) {
                    if (this.index.containsObject(Character.valueOf(c))) continue;
                    this.index.addToIndex((Character[])new Character[]{Character.valueOf(c)});
                }
            }
            this.N = this.index.size();
        }
    }
}

