/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import nuts.util.Counter;

public class RandomFactorizedInteger {
    private int n = 100;
    private Random rand = new Random(1L);
    private Set<Integer> primes = RandomFactorizedInteger.primes(this.n);

    private boolean isPrime(int i) {
        return this.primes.contains(i);
    }

    private int next(int current) {
        return this.rand.nextInt(current) + 1;
    }

    public int randomProduct() {
        int current = this.n;
        int prod = 1;
        while (current > 1) {
            if (!this.isPrime(current = this.next(current))) continue;
            prod *= current;
        }
        return prod;
    }

    public int next() {
        int result;
        while (this.isBad(result = this.randomProduct())) {
        }
        return result;
    }

    private boolean isBad(int r) {
        if (r > this.n) {
            return true;
        }
        return this.rand.nextDouble() >= (double)r / (double)this.n;
    }

    public static Set<Integer> primes(int n) {
        ArrayList<Integer> sieve = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            sieve.add(i);
        }
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 2; i < n; ++i) {
            if (sieve.get(i) == null) continue;
            result.add((Integer)sieve.get(i));
            int f = 2;
            while (f * (Integer)sieve.get(i) < n) {
                sieve.set(f * (Integer)sieve.get(i), null);
                ++f;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        Counter<Integer> counter = new Counter<Integer>();
        RandomFactorizedInteger rfi = new RandomFactorizedInteger();
        for (int i = 0; i < 10000000; ++i) {
            counter.incrementCount(rfi.next(), 1.0);
        }
        System.out.println(counter);
    }
}

