/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import spoon.reflect.code.CtBlock;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;

public class ExecutableFactory
extends SubFactory {
    public ExecutableFactory(Factory factory) {
        super(factory);
    }

    public CtAnonymousExecutable createAnonymous(CtClass<?> target, CtBlock<?> body) {
        CtAnonymousExecutable a = this.factory.Core().createAnonymousExecutable();
        target.addAnonymousExecutable(a);
        a.setBody(body);
        return a;
    }

    public <T> CtParameter<T> createParameter(CtExecutable<?> parent, CtTypeReference<T> type, String name) {
        CtParameter<T> parameter = this.factory.Core().createParameter();
        parameter.setType(type);
        parameter.setSimpleName(name);
        if (parent != null) {
            parent.addParameter(parameter);
        }
        return parameter;
    }

    public <T> CtParameterReference<T> createParameterReference(CtParameter<T> parameter) {
        CtParameterReference ref = this.factory.Core().createParameterReference();
        if (parameter.getParent() != null) {
            ref.setDeclaringExecutable(this.factory.Executable().createReference(parameter.getParent()));
        }
        ref.setSimpleName(parameter.getSimpleName());
        ref.setType(parameter.getType());
        return ref;
    }

    public <T> CtExecutableReference<T> createReference(CtExecutable<T> e) {
        CtTypeReference[] refs = new CtTypeReference[e.getParameters().size()];
        int i = 0;
        for (CtParameter<?> param : e.getParameters()) {
            refs[i++] = param.getType();
        }
        if (e instanceof CtMethod) {
            return this.createReference(((CtMethod)e).getDeclaringType().getReference(), ((CtMethod)e).getType(), e.getSimpleName(), refs);
        }
        return this.createReference(((CtConstructor)e).getDeclaringType().getReference(), ((CtConstructor)e).getType(), "<init>", refs);
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, CtTypeReference<T> type, String methodName, CtTypeReference<?> ... parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList();
        for (CtTypeReference<?> ref : parameterTypes) {
            l.add(ref);
        }
        methodRef.setActualTypeArguments(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, boolean isStatic, CtTypeReference<T> type, String methodName, CtTypeReference<?> ... parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setStatic(isStatic);
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList();
        for (CtTypeReference<?> ref : parameterTypes) {
            l.add(ref);
        }
        methodRef.setActualTypeArguments(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, boolean isStatic, CtTypeReference<T> type, String methodName, List<CtTypeReference<?>> parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setStatic(isStatic);
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList();
        for (CtTypeReference<?> ref : parameterTypes) {
            l.add(ref);
        }
        methodRef.setActualTypeArguments(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(CtTypeReference<?> declaringType, CtTypeReference<T> type, String methodName, List<CtTypeReference<?>> parameterTypes) {
        CtExecutableReference<T> methodRef = this.factory.Core().createExecutableReference();
        methodRef.setDeclaringType(declaringType);
        methodRef.setSimpleName(methodName);
        methodRef.setType(type);
        ArrayList l = new ArrayList();
        for (CtTypeReference<?> ref : parameterTypes) {
            l.add(ref);
        }
        methodRef.setActualTypeArguments(l);
        return methodRef;
    }

    public <T> CtExecutableReference<T> createReference(String signature) {
        CtExecutableReference executableRef = this.factory.Core().createExecutableReference();
        String type = signature.substring(0, signature.indexOf(" "));
        String declaringType = signature.substring(signature.indexOf(" ") + 1, signature.indexOf("#"));
        String executableName = signature.substring(signature.indexOf("#") + 1, signature.indexOf("("));
        executableRef.setSimpleName(executableName);
        executableRef.setDeclaringType(this.factory.Type().createReference(declaringType));
        CtTypeReference typeRef = this.factory.Type().createReference(type);
        executableRef.setType(typeRef);
        String parameters = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
        StringTokenizer t = new StringTokenizer(parameters, ",");
        while (t.hasMoreTokens()) {
            String paramType = t.nextToken();
            executableRef.addActualTypeArgument(this.factory.Type().createReference(paramType));
        }
        return executableRef;
    }
}

