/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments.pi;

import JSci.instruments.PositionControlAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class Mercury
extends PositionControlAdapter {
    private int port;
    private int axis;
    private double bias = 0.0;
    private String type = "";
    private String version = "";
    private static final int numAxis = 10;
    private static final int numPorts = 10;
    private static DataInput rfi = null;
    private static DataOutput rfo = null;
    private Preferences persPref = Preferences.userRoot().node("/it/unimi/pi/Mercury");
    private double currPos = Double.NaN;
    private boolean motor_on = true;
    private boolean brake_on;
    protected static final String EVENT_MOTION_COMPLETE = "Motion complete";
    protected static final String EVENT_WRAP_AROUND = "Wrap around";
    protected static final String EVENT_BREAKPOINT1 = "Breakpoint 1";
    protected static final String EVENT_CAPTURE_RECEIVED = "Capture received";
    protected static final String EVENT_MOTION_ERROR = "Motion error";
    protected static final String EVENT_POS_LIMIT = "Positive limit";
    protected static final String EVENT_NEG_LIMIT = "Negative limit";
    protected static final String EVENT_INSTRUCTION_ERR = "Instruction error";
    protected static final String EVENT_COMMUNICATION_ERR = "Communication error";
    protected static final String EVENT_BREAKPOINT2 = "Breakpoint 2";
    protected static final String SIGNAL_ENCODER_A = "Encoder A";
    protected static final String SIGNAL_ENCODER_B = "Encoder B";
    protected static final String SIGNAL_ENCODER_INDEX = "Encoder index";
    protected static final String SIGNAL_ENCODER_HOME = "Encoder home";
    protected static final String SIGNAL_POS_LIMIT = "Positive limit";
    protected static final String SIGNAL_NEG_LIMIT = "Negative limit";
    protected static final String SIGNAL_AXIS_IN = "Axis in";
    protected static final String SIGNAL_HALL_A = "Hall A";
    protected static final String SIGNAL_HALL_B = "Hall B";
    protected static final String SIGNAL_HALL_C = "Hall C";
    protected static final String SIGNAL_AXIS_OUT = "Axis out";
    protected static final String SIGNAL_STEP_OUTPUT = "Step output";
    protected static final String SIGNAL_MOTOR_OUTPUT = "Motor output";
    protected static final String ACTIVITY_PHASING_INITD = "Not for the PI boards!!!";
    protected static final String ACTIVITY_MAX_VELOCITY = "Running at max velocity";
    protected static final String ACTIVITY_TRACKING = "Tracking";
    protected static final String ACTIVITY_PROFILE_MODE_0 = "Profile mode 0";
    protected static final String ACTIVITY_PROFILE_MODE_1 = "Profile mode 1";
    protected static final String ACTIVITY_PROFILE_MODE_2 = "Profile mode 2";
    protected static final String ACTIVITY_RESERVED = "Reserved";
    protected static final String ACTIVITY_AXIS_SETTLED = "Setteled";
    protected static final String ACTIVITY_MOTOR_STATUS = "Motor status";
    protected static final String ACTIVITY_POSITION_CAPTURE = "Position capture";
    protected static final String ACTIVITY_IN_MOTION = "In motion";
    protected static final String ACTIVITY_ACT_POS_LIMIT = "Actual positive limit";
    protected static final String ACTIVITY_ACT_NEG_LIMIT = "Actual negative limit";
    public static final String C150PD = "C-150.PD";
    public static final String C136 = "C-136.10";
    public static final String M126PD = "M-126.PD";
    public static final String RAW = "Raw";
    JFrame setLimitsDialog = null;

    private byte readByteWithoutEOF() throws IOException {
        boolean bl = false;
        byte by = 0;
        while (!bl) {
            try {
                by = rfi.readByte();
                bl = true;
            }
            catch (EOFException eOFException) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return by;
    }

    private void writeByte(int n) throws IOException {
        rfo.writeByte(n);
    }

    private void writeBytes(String string) throws IOException {
        rfo.writeBytes(string);
    }

    private String readLine() {
        String string = "";
        try {
            char c;
            while ((c = (char)this.readByteWithoutEOF()) != '\r') {
                string = string + c;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with port " + this.port + "; exception " + iOException);
        }
        try {
            if (this.readByteWithoutEOF() == 10) {
                this.readByteWithoutEOF();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with port " + this.port + "; exception " + iOException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mercury(int n, DataInput dataInput, DataOutput dataOutput, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(n2 + ": axis number should be positive");
        }
        if (n < 0) {
            throw new IllegalArgumentException(n2 + ": ttyS port number should be positive");
        }
        this.port = n;
        this.axis = n2;
        rfi = dataInput;
        rfo = dataOutput;
        try {
            DataOutput dataOutput2 = dataOutput;
            synchronized (dataOutput2) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("ve");
                this.writeByte(13);
                try {
                    dataInput.readByte();
                }
                catch (EOFException eOFException) {
                    this.writeByte(1);
                    this.writeBytes("" + this.axis);
                    this.writeBytes("rt");
                    this.writeByte(13);
                }
                this.readLine();
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("ve");
                this.writeByte(13);
                this.version = this.readLine();
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("bf");
                this.writeByte(13);
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("mn");
                this.writeByte(13);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error writing to /dev/ttyS" + this.port);
        }
        this.bias = 0.0;
        this.bias = this.persPref.getDouble("zero-" + this.port + "-" + this.axis, 0.0) - this.doGetPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLimitSwitches(boolean bl) {
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                if (bl) {
                    this.writeBytes("lh");
                } else {
                    this.writeBytes("ll");
                }
                this.writeByte(13);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findCenter() {
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("fe");
                this.writeByte(13);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
    }

    public void setPosition(double d) {
        if (d == this.currPos) {
            return;
        }
        this.currPos = d;
        this.doSetPosition(d);
        this.persPref.putDouble("zero-" + this.port + "-" + this.axis, d);
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetPosition(double d) {
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("ma" + (long)(d - this.bias));
                this.writeByte(13);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
    }

    public double getPosition() {
        if (Double.isNaN(this.currPos)) {
            this.currPos = this.doGetPosition();
        }
        return Math.rint(this.currPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double doGetPosition() {
        double d = 0.0;
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("tt");
                this.writeByte(13);
                d = Double.parseDouble(this.readLine().substring(2));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
        return d + this.bias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getActualPosition() {
        double d = 0.0;
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("tp");
                this.writeByte(13);
                d = Double.parseDouble(this.readLine().substring(2));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
        return d + this.bias;
    }

    public double getMinimum() {
        return Math.rint(this.persPref.getDouble("min-" + this.port + "-" + this.axis, this.getPosition()));
    }

    public double getMaximum() {
        return Math.rint(this.persPref.getDouble("max-" + this.port + "-" + this.axis, this.getPosition()));
    }

    public void setMinimum(double d) {
        this.persPref.putDouble("min-" + this.port + "-" + this.axis, d);
    }

    public void setMaximum(double d) {
        this.persPref.putDouble("max-" + this.port + "-" + this.axis, d);
    }

    public String getUnit() {
        return "counts";
    }

    public double getMinorStep() {
        return 400.0;
    }

    public double getMajorStep() {
        return 4000.0;
    }

    public double getPositionError() {
        return this.doGetPositionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double doGetPositionError() {
        double d = 0.0;
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("te");
                this.writeByte(13);
                d = Double.parseDouble(this.readLine().substring(2));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVelocity(double d) {
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("sv" + (long)d);
                this.writeByte(13);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getVelocity() {
        double d = 0.0;
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("ty");
                this.writeByte(13);
                d = Double.parseDouble(this.readLine().substring(2));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getActualVelocity() {
        double d = 0.0;
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                this.writeBytes("tv");
                this.writeByte(13);
                d = Double.parseDouble(this.readLine().substring(2));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
        return d;
    }

    public double getMaxVelocity() {
        return Double.POSITIVE_INFINITY;
    }

    public double getVelocityStep() {
        return 100000.0;
    }

    public String getVelocityUnit() {
        return "counts/cycle";
    }

    protected void clearErrors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMotorOn(boolean bl) {
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                if (bl) {
                    this.writeBytes("mn");
                } else {
                    this.writeBytes("mf");
                }
                this.writeByte(13);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
        this.motor_on = bl;
    }

    protected boolean getMotorOn() {
        return this.motor_on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBrake(boolean bl) {
        try {
            DataOutput dataOutput = rfo;
            synchronized (dataOutput) {
                this.writeByte(1);
                this.writeBytes("" + this.axis);
                if (bl) {
                    this.writeBytes("bn");
                } else {
                    this.writeBytes("bf");
                }
                this.writeByte(13);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot communicate with ttyS" + this.port);
        }
        this.brake_on = bl;
    }

    protected boolean getBrake() {
        return this.brake_on;
    }

    protected Hashtable getEventStatus() {
        return null;
    }

    protected Hashtable getSignalStatus() {
        return null;
    }

    protected Hashtable getActivityStatus() {
        return null;
    }

    public void sleep() {
        do {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Math.abs(this.doGetPositionError()) > 19.5);
    }

    protected JPanel createPositionPanel(boolean bl, boolean bl2, boolean bl3) {
        JButton jButton;
        JButton jButton2;
        JButton jButton3 = new JButton("Limits");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout());
        if (bl2) {
            jButton2 = new JButton("^");
            jButton = new JButton("v");
            jPanel.add("North", jButton2);
            jPanel.add("South", jButton);
        } else {
            jButton2 = new JButton(">");
            jButton = new JButton("<");
            jPanel.add("East", jButton2);
            jPanel.add("West", jButton);
        }
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.getPosition(), this.getMinimum(), this.getMaximum(), this.getMinorStep()));
        Dimension dimension = jSpinner.getPreferredSize();
        dimension.setSize(100.0, dimension.getHeight());
        jSpinner.setPreferredSize(dimension);
        jPanel2.add(jSpinner);
        jPanel2.add(new JLabel("(" + this.getUnit() + ")"));
        jPanel2.add(jPanel);
        if (bl) {
            JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(this.getPosition(), this.getMinimum(), this.getMaximum(), this.getMinorStep()));
            dimension = jSpinner2.getPreferredSize();
            dimension.setSize(100.0, dimension.getHeight());
            jSpinner2.setPreferredSize(dimension);
            jSpinner2.setEnabled(false);
            jPanel2.add(new JLabel("Actual: "));
            jPanel2.add(jSpinner2);
            jPanel2.add(new JLabel("(" + this.getUnit() + ")"));
            class ActposChangeListener
            implements ChangeListener,
            Runnable {
                private boolean running = false;
                private final /* synthetic */ JSpinner val$actpos;

                ActposChangeListener(JSpinner jSpinner) {
                    this.val$actpos = jSpinner;
                }

                public void run() {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            Mercury.this.sleep();
                            running = false;
                        }
                    });
                    thread.setDaemon(true);
                    thread.start();
                    do {
                        this.val$actpos.setValue(new Double(Mercury.this.getActualPosition()));
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (this.running);
                    this.val$actpos.setValue(new Double(Mercury.this.getActualPosition()));
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.running) {
                        return;
                    }
                    Thread thread = new Thread(this);
                    thread.setDaemon(true);
                    this.running = true;
                    thread.start();
                }
            }
            this.addChangeListener(new ActposChangeListener(jSpinner2));
        }
        if (!bl3) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d = Mercury.this.getPosition() - Mercury.this.getMajorStep();
                    if (d >= Mercury.this.getMinimum()) {
                        jSpinner.setValue(new Double(d));
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d = Mercury.this.getPosition() + Mercury.this.getMajorStep();
                    if (d <= Mercury.this.getMaximum()) {
                        jSpinner.setValue(new Double(d));
                    }
                }
            });
        } else {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d = Mercury.this.getPosition() + Mercury.this.getMajorStep();
                    if (d <= Mercury.this.getMaximum()) {
                        jSpinner.setValue(new Double(d));
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d = Mercury.this.getPosition() - Mercury.this.getMajorStep();
                    if (d >= Mercury.this.getMinimum()) {
                        jSpinner.setValue(new Double(d));
                    }
                }
            });
        }
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinner.getValue();
                Mercury.this.setPosition(d);
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jSpinner.setValue(new Double(Mercury.this.getPosition()));
            }
        });
        jPanel2.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Mercury.this.setLimitsDialog == null) {
                    Mercury.this.setLimits();
                }
                if (!Mercury.this.setLimitsDialog.isVisible()) {
                    Mercury.this.setLimitsDialog.setVisible(true);
                }
                Mercury.this.setLimitsDialog.toFront();
            }
        });
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Position"));
        return jPanel2;
    }

    protected JPanel createVelocityPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.getVelocity(), 0.0, this.getMaxVelocity(), this.getVelocityStep()));
        JRadioButton jRadioButton = new JRadioButton(ACTIVITY_IN_MOTION);
        jRadioButton.setSelected(false);
        jRadioButton.setEnabled(false);
        Dimension dimension = jSpinner.getPreferredSize();
        dimension.setSize(100.0, dimension.getHeight());
        jSpinner.setPreferredSize(dimension);
        jPanel.add(jSpinner);
        jPanel.add(new JLabel("(" + this.getVelocityUnit() + ")"));
        if (bl) {
            JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(this.getActualVelocity(), -this.getMaxVelocity(), this.getMaxVelocity(), this.getVelocityStep()));
            dimension = jSpinner2.getPreferredSize();
            dimension.setSize(100.0, dimension.getHeight());
            jSpinner2.setPreferredSize(dimension);
            jSpinner2.setEnabled(false);
            jPanel.add(new JLabel("Actual: "));
            jPanel.add(jSpinner2);
            jPanel.add(new JLabel("(" + this.getVelocityUnit() + ")"));
            class ActvelChangeListener
            implements ChangeListener,
            Runnable {
                private boolean running = false;
                private final /* synthetic */ JRadioButton val$inMotion;
                private final /* synthetic */ JSpinner val$actvel;

                ActvelChangeListener(JRadioButton jRadioButton, JSpinner jSpinner) {
                    this.val$inMotion = jRadioButton;
                    this.val$actvel = jSpinner;
                }

                public void run() {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            val$inMotion.setSelected(true);
                            Mercury.this.sleep();
                            running = false;
                            val$inMotion.setSelected(false);
                        }
                    });
                    thread.setDaemon(true);
                    thread.start();
                    do {
                        this.val$actvel.setValue(new Double(Mercury.this.getActualVelocity()));
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (this.running);
                    this.val$actvel.setValue(new Double(Mercury.this.getActualVelocity()));
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.running) {
                        return;
                    }
                    Thread thread = new Thread(this);
                    thread.setDaemon(true);
                    this.running = true;
                    thread.start();
                }
            }
            this.addChangeListener(new ActvelChangeListener(jRadioButton, jSpinner2));
        }
        jPanel.add(jRadioButton);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinner.getValue();
                Mercury.this.setVelocity(d);
            }
        });
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Velocity"));
        return jPanel;
    }

    protected JPanel createButtonControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Find home");
        JButton jButton2 = new JButton("Motor ON");
        JButton jButton3 = new JButton("Brake ON");
        JButton jButton4 = new JButton("Motor mode 1");
        JButton jButton5 = new JButton("DAC");
        JButton jButton6 = new JButton("Clear error");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Mercury.this.findCenter();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Mercury.this.setMotorOn(!Mercury.this.getMotorOn());
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Mercury.this.setBrake(!Mercury.this.getBrake());
            }
        });
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Mercury.this.clearErrors();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton6);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Motor controls"));
        return jPanel;
    }

    public abstract Component getControlComponent();

    public static Mercury createMotorDevice(String string, int n, DataInput dataInput, DataOutput dataOutput, int n2, double d) {
        String string2;
        String string3;
        double d2;
        double d3;
        double d4;
        if (d == 0.0) {
            throw new IllegalArgumentException("Gear factor = 0");
        }
        if (!(string.equals(RAW) || string.equals(C150PD) || string.equals(C136) || string.equals(M126PD))) {
            throw new IllegalArgumentException("Motor type not supported");
        }
        if (string.equals(RAW) && d != 1.0) {
            throw new IllegalArgumentException("Gear factor must be 1.0 for Row motor type");
        }
        Mercury mercury = null;
        final JPanel jPanel = new JPanel();
        final String string4 = "vel-" + n + "-" + n2 + "-" + string;
        if (string.equals(RAW)) {
            d4 = 1.0;
            d3 = 1.0;
            d2 = Double.POSITIVE_INFINITY;
            string3 = "counts";
            string2 = "counts/s";
        } else if (string.equals(C150PD)) {
            d4 = d / 4000.0;
            d3 = d / 4000.0;
            d2 = 100.0 * Math.abs(d);
            string3 = "turns";
            string2 = "turns/s";
        } else if (string.equals(C136)) {
            d4 = d / 2000.0;
            d3 = d / 2000.0;
            d2 = 3.3 * Math.abs(d);
            string3 = "turns";
            string2 = "turns/s";
        } else {
            if (!string.equals(M126PD)) {
                throw new IllegalArgumentException("Unknown motor type: " + string);
            }
            d4 = 1.25E-4 * d;
            d3 = 1.25E-4 * d;
            d2 = 15.0 * Math.abs(d);
            string3 = "mm";
            string2 = "mm/s";
        }
        mercury = new Mercury(n, dataInput, dataOutput, n2){

            public void setPosition(double d) {
                if (d >= this.getMinimum() && d <= this.getMaximum()) {
                    super.setPosition(d / d4);
                }
            }

            public double getPosition() {
                return super.getPosition() * d4;
            }

            public double getActualPosition() {
                return super.getActualPosition() * d4;
            }

            public double getMinimum() {
                return d4 * (d4 > 0.0 ? super.getMinimum() : super.getMaximum());
            }

            public double getMaximum() {
                return d4 * (d4 > 0.0 ? super.getMaximum() : super.getMinimum());
            }

            public void setMinimum(double d) {
                if (d4 > 0.0) {
                    super.setMinimum(d / d4);
                } else {
                    super.setMaximum(d / d4);
                }
            }

            public void setMaximum(double d) {
                if (d4 > 0.0) {
                    super.setMaximum(d / d4);
                } else {
                    super.setMinimum(d / d4);
                }
            }

            public String getUnit() {
                return string3;
            }

            public double getMinorStep() {
                return super.getMinorStep() * Math.abs(d4);
            }

            public double getMajorStep() {
                return super.getMajorStep() * Math.abs(d4);
            }

            public double getPositionError() {
                return super.getPositionError() * d4;
            }

            public void setVelocity(double d) {
                if (d > 0.0 && d < this.getMaxVelocity()) {
                    super.setVelocity(d / Math.abs(d3));
                    ((Mercury)this).persPref.putDouble(string4, d);
                }
            }

            public double getVelocity() {
                return super.getVelocity() * Math.abs(d3);
            }

            public double getActualVelocity() {
                return super.getActualVelocity() * d3;
            }

            public double getMaxVelocity() {
                return d2;
            }

            public double getVelocityStep() {
                return super.getVelocityStep() * Math.abs(d3);
            }

            public String getVelocityUnit() {
                return string2;
            }

            public Component getControlComponent() {
                return jPanel;
            }
        };
        if (string.equals(M126PD)) {
            mercury.setLimitSwitches(true);
        }
        if (!string.equals(RAW)) {
            mercury.setMotorOn(true);
        }
        if (!(mercury.getPosition() >= mercury.getMinimum()) || !(mercury.getPosition() <= mercury.getMaximum())) {
            throw new IllegalArgumentException("( Minimum <= Position <= Maximum ) failed");
        }
        mercury.type = string;
        mercury.setVelocity(mercury.persPref.getDouble("vel-" + mercury.port + "-" + mercury.axis + "-" + mercury.type, 0.1));
        jPanel.setLayout(new BorderLayout());
        if (string.equals(M126PD)) {
            jPanel.add("North", mercury.createPositionPanel(true, true, false));
        } else {
            jPanel.add("North", mercury.createPositionPanel(true, false, false));
        }
        jPanel.add("Center", mercury.createVelocityPanel(true));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "ttyS" + n + " Axis " + n2 + " " + string));
        return mercury;
    }

    public static Mercury createMotorDevice(String string, int n, int n2, double d) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile("/dev/ttyS" + n, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("/dev/ttyS" + n + "does not exist");
        }
        return Mercury.createMotorDevice(string, n, randomAccessFile, randomAccessFile, n2, d);
    }

    public static Mercury createMotorDevice(String string, int n, int n2) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile("/dev/ttyS" + n, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("/dev/ttyS" + n + "does not exist");
        }
        return Mercury.createMotorDevice(string, n, randomAccessFile, randomAccessFile, n2, 1.0);
    }

    public String toString() {
        return this.getClass().getName() + "[\nPort=ttyS" + this.port + ",axis=" + this.axis + ",type=" + this.type + ",version=" + this.version + "]";
    }

    private static void printHelp() {
        System.out.println("Useful controls for the Mercury board. Parameters can be supplied.\nSyntax:\njava it.unimi.pi.Mercury {options} {commands}\nThe options can be:\n-h : print the help\n-m type : set the motor type (\"Raw\" by default)\n-p ttyS_number : set the ttyS port number (0 by default)\n-n axis_number : set the axis number (0 by default)\n-g gear_factor : set the gear factor (1 by default)\nThe commands can be:\nsetMinimum position : set the minimum of the position (only root can do this)\nsetMaximum position : set the maximum of the position (only root can do this)\nsetPosition position : move the motor to the given position\nsetLimits : graphical interface for setting limits of the given motor (only root can do this)\nmonitor : open a window with the control component for the desired motor.\nmotors : print a list of known motor types. \"Raw\" is a generic motor, with the\nunits used by the board.\n");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        int n;
        String string = RAW;
        int n2 = 0;
        double d = 1.0;
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-m")) {
                if (++n >= stringArray.length) {
                    Mercury.printHelp();
                }
                string = stringArray[n];
                continue;
            }
            if (stringArray[n].equals("-p")) {
                if (++n >= stringArray.length) {
                    Mercury.printHelp();
                }
                n3 = Integer.parseInt(stringArray[n]);
                continue;
            }
            if (stringArray[n].equals("-n")) {
                if (++n >= stringArray.length) {
                    Mercury.printHelp();
                }
                n2 = Integer.parseInt(stringArray[n]);
                continue;
            }
            if (stringArray[n].equals("-g")) {
                if (++n >= stringArray.length) {
                    Mercury.printHelp();
                }
                d = Double.parseDouble(stringArray[n]);
                continue;
            }
            if (!stringArray[n].equals("-h")) break;
            Mercury.printHelp();
        }
        Mercury mercury = Mercury.createMotorDevice(string, n3, n2, d);
        while (n < stringArray.length) {
            if (stringArray[n].equals("setMinimum")) {
                if (++n >= stringArray.length) {
                    Mercury.printHelp();
                }
                mercury.setMinimum(Double.parseDouble(stringArray[n]));
            } else if (stringArray[n].equals("setMaximum")) {
                if (++n >= stringArray.length) {
                    Mercury.printHelp();
                }
                mercury.setMaximum(Double.parseDouble(stringArray[n]));
            } else if (stringArray[n].equals("setPosition")) {
                if (++n >= stringArray.length) {
                    Mercury.printHelp();
                }
                mercury.setPosition(Double.parseDouble(stringArray[n]));
            } else if (stringArray[n].equals("setLimits")) {
                mercury.setLimits();
            } else if (stringArray[n].equals("monitor")) {
                JFrame jFrame = new JFrame("Mercury");
                jFrame.getContentPane().add(mercury.getControlComponent());
                jFrame.setDefaultCloseOperation(2);
                jFrame.pack();
                jFrame.show();
            } else if (stringArray[n].equals("motors")) {
                System.out.println("Supported motor types:\nRaw\nC-150.PD\nC-136.10\nM-126.PD\n\n");
            } else {
                Mercury.printHelp();
            }
            ++n;
        }
    }

    public void setLimits() {
        this.setLimitsDialog = new JFrame("Axis " + this.axis + " " + this.type + " Set limits");
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.getMinimum(), Double.NEGATIVE_INFINITY, this.getPosition(), this.getMinorStep()));
        final JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(this.getPosition(), this.getMinimum(), this.getMaximum(), this.getMinorStep()));
        final JSpinner jSpinner3 = new JSpinner(new SpinnerNumberModel(this.getMaximum(), this.getPosition(), Double.POSITIVE_INFINITY, this.getMinorStep()));
        final JRadioButton jRadioButton = new JRadioButton("None", true);
        final JRadioButton jRadioButton2 = new JRadioButton("Min", false);
        final JRadioButton jRadioButton3 = new JRadioButton("Max", false);
        JButton jButton = new JButton("Move to min");
        JButton jButton2 = new JButton("Move to max");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinner.getValue();
                Mercury.this.setMinimum(d);
                if (jRadioButton.isSelected()) {
                    ((SpinnerNumberModel)jSpinner2.getModel()).setMinimum(new Double(Mercury.this.getMinimum()));
                }
                if (jRadioButton2.isSelected()) {
                    jSpinner2.setValue(new Double(Mercury.this.getMinimum()));
                    ((SpinnerNumberModel)jSpinner2.getModel()).setMinimum(new Double(Mercury.this.getMinimum()));
                    ((SpinnerNumberModel)jSpinner2.getModel()).setMaximum(new Double(Mercury.this.getMinimum()));
                    ((SpinnerNumberModel)jSpinner3.getModel()).setMinimum(new Double(Mercury.this.getMinimum()));
                }
                if (jRadioButton3.isSelected()) {
                    ((SpinnerNumberModel)jSpinner3.getModel()).setMinimum(new Double(Mercury.this.getMinimum()));
                }
            }
        });
        jSpinner2.addChangeListener(new ChangeListener(){
            private double currPos = 0.0;

            public void stateChanged(ChangeEvent changeEvent) {
                double d;
                if (this.currPos == 0.0) {
                    this.currPos = Mercury.this.getPosition();
                }
                if ((d = ((Double)jSpinner2.getValue()).doubleValue()) == this.currPos) {
                    return;
                }
                this.currPos = d;
                Mercury.this.setPosition(d);
                if (jRadioButton.isSelected()) {
                    ((SpinnerNumberModel)jSpinner.getModel()).setMaximum(new Double(Mercury.this.getPosition()));
                    ((SpinnerNumberModel)jSpinner3.getModel()).setMinimum(new Double(Mercury.this.getPosition()));
                }
            }
        });
        jSpinner3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinner3.getValue();
                Mercury.this.setMaximum(d);
                if (jRadioButton.isSelected()) {
                    ((SpinnerNumberModel)jSpinner2.getModel()).setMaximum(new Double(Mercury.this.getMaximum()));
                }
                if (jRadioButton2.isSelected()) {
                    ((SpinnerNumberModel)jSpinner.getModel()).setMaximum(new Double(Mercury.this.getMaximum()));
                }
                if (jRadioButton3.isSelected()) {
                    jSpinner2.setValue(new Double(Mercury.this.getMaximum()));
                    ((SpinnerNumberModel)jSpinner2.getModel()).setMinimum(new Double(Mercury.this.getMaximum()));
                    ((SpinnerNumberModel)jSpinner2.getModel()).setMaximum(new Double(Mercury.this.getMaximum()));
                    ((SpinnerNumberModel)jSpinner.getModel()).setMaximum(new Double(Mercury.this.getMaximum()));
                }
            }
        });
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SpinnerNumberModel)jSpinner.getModel()).setMaximum(new Double(Mercury.this.getPosition()));
                ((SpinnerNumberModel)jSpinner3.getModel()).setMinimum(new Double(Mercury.this.getPosition()));
                ((SpinnerNumberModel)jSpinner2.getModel()).setMinimum(new Double(Mercury.this.getMinimum()));
                ((SpinnerNumberModel)jSpinner2.getModel()).setMaximum(new Double(Mercury.this.getMaximum()));
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jSpinner2.setValue(new Double(Mercury.this.getMinimum()));
                ((SpinnerNumberModel)jSpinner.getModel()).setMaximum(new Double(Mercury.this.getMaximum()));
                ((SpinnerNumberModel)jSpinner2.getModel()).setMinimum(new Double(Mercury.this.getMinimum()));
                ((SpinnerNumberModel)jSpinner2.getModel()).setMaximum(new Double(Mercury.this.getMinimum()));
                ((SpinnerNumberModel)jSpinner3.getModel()).setMinimum(new Double(Mercury.this.getMinimum()));
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jSpinner2.setValue(new Double(Mercury.this.getMaximum()));
                ((SpinnerNumberModel)jSpinner3.getModel()).setMinimum(new Double(Mercury.this.getMinimum()));
                ((SpinnerNumberModel)jSpinner2.getModel()).setMinimum(new Double(Mercury.this.getMaximum()));
                ((SpinnerNumberModel)jSpinner2.getModel()).setMaximum(new Double(Mercury.this.getMaximum()));
                ((SpinnerNumberModel)jSpinner.getModel()).setMaximum(new Double(Mercury.this.getMaximum()));
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton.isSelected()) {
                    jSpinner2.setValue(new Double(Mercury.this.getMinimum()));
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton.isSelected()) {
                    jSpinner2.setValue(new Double(Mercury.this.getMaximum()));
                }
            }
        });
        Dimension dimension = jSpinner.getPreferredSize();
        dimension = new Dimension(100, (int)dimension.getHeight());
        jSpinner.setPreferredSize(dimension);
        dimension = jSpinner2.getPreferredSize();
        dimension = new Dimension(100, (int)dimension.getHeight());
        jSpinner2.setPreferredSize(dimension);
        dimension = jSpinner3.getPreferredSize();
        dimension = new Dimension(100, (int)dimension.getHeight());
        jSpinner3.setPreferredSize(dimension);
        this.setLimitsDialog.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)new JLabel("Maximum:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)jSpinner3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)new JLabel(this.getUnit()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)new JLabel("Position:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)jSpinner2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)new JLabel(this.getUnit()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)new JLabel("Minimum:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)jSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)new JLabel(this.getUnit()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)new JLabel("Anchor to: "), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)jRadioButton2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)jRadioButton3, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLimitsDialog.getContentPane().add((Component)jButton2, gridBagConstraints);
        this.setLimitsDialog.pack();
        this.setLimitsDialog.setResizable(false);
        this.setLimitsDialog.setDefaultCloseOperation(2);
        this.setLimitsDialog.setVisible(true);
    }
}

