/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.DimensionException;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.ComplexLUCache;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.ComplexTridiagonalMatrix;
import JSci.maths.matrices.DiagonalMatrix;
import JSci.maths.matrices.DoubleDiagonalMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.matrices.TridiagonalMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.ComplexVector;

public class ComplexDiagonalMatrix
extends AbstractComplexSquareMatrix
implements DiagonalMatrix {
    protected final double[] diagRe;
    protected final double[] diagIm;

    public ComplexDiagonalMatrix(double[] dArray, double[] dArray2) {
        super(dArray.length);
        this.diagRe = dArray;
        this.diagIm = dArray2;
    }

    public ComplexDiagonalMatrix(int n) {
        this(new double[n], new double[n]);
    }

    public ComplexDiagonalMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        for (int i = 0; i < this.numRows; ++i) {
            if (complexArray[i].length != complexArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diagRe[i] = complexArray[i][i].real();
            this.diagIm[i] = complexArray[i][i].imag();
        }
    }

    public ComplexDiagonalMatrix(Complex[] complexArray) {
        this(complexArray.length);
        this.diagRe[0] = complexArray[0].real();
        this.diagIm[0] = complexArray[0].imag();
        for (int i = 1; i < complexArray.length; ++i) {
            this.diagRe[i] = complexArray[i].real();
            this.diagIm[i] = complexArray[i].imag();
        }
    }

    public static ComplexDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 1.0;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix, double d) {
        if (abstractComplexMatrix instanceof DiagonalMatrix) {
            if (this.numRows != abstractComplexMatrix.rows() || this.numCols != abstractComplexMatrix.columns()) {
                return false;
            }
            double d2 = 0.0;
            double d3 = this.diagRe[0] - abstractComplexMatrix.getRealElement(0, 0);
            double d4 = this.diagIm[0] - abstractComplexMatrix.getImagElement(0, 0);
            d2 += d3 * d3 + d4 * d4;
            for (int i = 1; i < this.numRows; ++i) {
                d3 = this.diagRe[i] - abstractComplexMatrix.getRealElement(i, i);
                d4 = this.diagIm[i] - abstractComplexMatrix.getImagElement(i, i);
                d2 += d3 * d3 + d4 * d4;
            }
            return d2 <= d * d;
        }
        return super.equals(abstractComplexMatrix);
    }

    public AbstractDoubleMatrix real() {
        return new DoubleDiagonalMatrix(this.diagRe);
    }

    public AbstractDoubleMatrix imag() {
        return new DoubleDiagonalMatrix(this.diagIm);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return new Complex(this.diagRe[n], this.diagIm[n]);
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getRealElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diagRe[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getImagElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diagIm[n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols || n != n2) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diagRe[n] = complex.real();
        this.diagIm[n] = complex.imag();
    }

    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols || n != n2) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diagRe[n] = d;
        this.diagIm[n] = d2;
    }

    public Complex det() {
        double d = this.diagRe[0];
        double d2 = this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            double d3 = d * this.diagRe[i] - d2 * this.diagIm[i];
            d2 = d2 * this.diagRe[i] + d * this.diagIm[i];
            d = d3;
        }
        return new Complex(d, d2);
    }

    public Complex trace() {
        double d = this.diagRe[0];
        double d2 = this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            d += this.diagRe[i];
            d2 += this.diagIm[i];
        }
        return new Complex(d, d2);
    }

    public double infNorm() {
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            double d2 = this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return Math.sqrt(d);
    }

    public double frobeniusNorm() {
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            d += this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i];
        }
        return Math.sqrt(d);
    }

    public double operatorNorm() {
        return this.infNorm();
    }

    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.add((ComplexDiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                Complex complex = abstractComplexSquareMatrix.getElement(n, 0);
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                for (int i = 1; i < this.numCols; ++i) {
                    complex = abstractComplexSquareMatrix.getElement(n, i);
                    dArray[n][i] = complex.real();
                    dArray2[n][i] = complex.imag();
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                double[] dArray3 = dArray[n];
                int n2 = n;
                dArray3[n2] = dArray3[n2] + this.diagRe[n];
                double[] dArray4 = dArray2[n];
                int n3 = n;
                dArray4[n3] = dArray4[n3] + this.diagIm[n];
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                System.arraycopy(complexSquareMatrix.matrixRe[n], 0, dArray[n], 0, this.numCols);
                System.arraycopy(complexSquareMatrix.matrixIm[n], 0, dArray2[n], 0, this.numCols);
            }
            for (n = 0; n < this.numRows; ++n) {
                double[] dArray3 = dArray[n];
                int n2 = n;
                dArray3[n2] = dArray3[n2] + this.diagRe[n];
                double[] dArray4 = dArray2[n];
                int n3 = n;
                dArray4[n3] = dArray4[n3] + this.diagIm[n];
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (this.numRows == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(this.numRows);
            System.arraycopy(complexTridiagonalMatrix.ldiagRe, 0, complexTridiagonalMatrix2.ldiagRe, 0, complexTridiagonalMatrix.ldiagRe.length);
            System.arraycopy(complexTridiagonalMatrix.ldiagIm, 0, complexTridiagonalMatrix2.ldiagIm, 0, complexTridiagonalMatrix.ldiagIm.length);
            System.arraycopy(complexTridiagonalMatrix.udiagRe, 0, complexTridiagonalMatrix2.udiagRe, 0, complexTridiagonalMatrix.udiagRe.length);
            System.arraycopy(complexTridiagonalMatrix.udiagIm, 0, complexTridiagonalMatrix2.udiagIm, 0, complexTridiagonalMatrix.udiagIm.length);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] + complexTridiagonalMatrix.diagRe[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] + complexTridiagonalMatrix.diagIm[0];
            for (int i = 1; i < this.numRows; ++i) {
                complexTridiagonalMatrix2.diagRe[i] = this.diagRe[i] + complexTridiagonalMatrix.diagRe[i];
                complexTridiagonalMatrix2.diagIm[i] = this.diagIm[i] + complexTridiagonalMatrix.diagIm[i];
            }
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix addTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (n == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] + complex.real();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] + complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = complex.real();
            complexTridiagonalMatrix.udiagIm[0] = complex.imag();
            --n;
            for (int i = 1; i < n; ++i) {
                complex = abstractComplexSquareMatrix.getElement(i, i - 1);
                complexTridiagonalMatrix.ldiagRe[i] = complex.real();
                complexTridiagonalMatrix.ldiagIm[i] = complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i);
                complexTridiagonalMatrix.diagRe[i] = this.diagRe[i] + complex.real();
                complexTridiagonalMatrix.diagIm[i] = this.diagIm[i] + complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i + 1);
                complexTridiagonalMatrix.udiagRe[i] = complex.real();
                complexTridiagonalMatrix.udiagIm[i] = complex.imag();
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = complex.real();
            complexTridiagonalMatrix.ldiagIm[n] = complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] + complex.real();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] + complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix add(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.numRows == complexDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] + complexDiagonalMatrix.diagRe[0];
            dArray2[0] = this.diagIm[0] + complexDiagonalMatrix.diagIm[0];
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diagRe[i] + complexDiagonalMatrix.diagRe[i];
                dArray2[i] = this.diagIm[i] + complexDiagonalMatrix.diagIm[i];
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                Complex complex = abstractComplexSquareMatrix.getElement(n, 0);
                dArray[n][0] = -complex.real();
                dArray2[n][0] = -complex.imag();
                for (int i = 1; i < this.numCols; ++i) {
                    complex = abstractComplexSquareMatrix.getElement(n, i);
                    dArray[n][i] = -complex.real();
                    dArray2[n][i] = -complex.imag();
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                double[] dArray3 = dArray[n];
                int n2 = n;
                dArray3[n2] = dArray3[n2] + this.diagRe[n];
                double[] dArray4 = dArray2[n];
                int n3 = n;
                dArray4[n3] = dArray4[n3] + this.diagIm[n];
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            int n;
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = -complexSquareMatrix.matrixRe[i][0];
                dArray2[i][0] = -complexSquareMatrix.matrixIm[i][0];
                for (n = 1; n < this.numCols; ++n) {
                    dArray[i][n] = -complexSquareMatrix.matrixRe[i][n];
                    dArray2[i][n] = -complexSquareMatrix.matrixIm[i][n];
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                double[] dArray3 = dArray[n];
                int n2 = n;
                dArray3[n2] = dArray3[n2] + this.diagRe[n];
                double[] dArray4 = dArray2[n];
                int n3 = n;
                dArray4[n3] = dArray4[n3] + this.diagIm[n];
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (n == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] - complexTridiagonalMatrix.diagRe[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] - complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.udiagRe[0] = -complexTridiagonalMatrix.udiagRe[0];
            complexTridiagonalMatrix2.udiagIm[0] = -complexTridiagonalMatrix.udiagIm[0];
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.ldiagRe[i] = -complexTridiagonalMatrix.ldiagRe[i];
                complexTridiagonalMatrix2.ldiagIm[i] = -complexTridiagonalMatrix.ldiagIm[i];
                complexTridiagonalMatrix2.diagRe[i] = this.diagRe[i] - complexTridiagonalMatrix.diagRe[i];
                complexTridiagonalMatrix2.diagIm[i] = this.diagIm[i] - complexTridiagonalMatrix.diagIm[i];
                complexTridiagonalMatrix2.udiagRe[i] = -complexTridiagonalMatrix.udiagRe[i];
                complexTridiagonalMatrix2.udiagIm[i] = -complexTridiagonalMatrix.udiagIm[i];
            }
            complexTridiagonalMatrix2.ldiagRe[n] = -complexTridiagonalMatrix.ldiagRe[n];
            complexTridiagonalMatrix2.ldiagIm[n] = -complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] - complexTridiagonalMatrix.diagRe[n];
            complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] - complexTridiagonalMatrix.diagIm[n];
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix subtractTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (n == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] - complex.real();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] - complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = -complex.real();
            complexTridiagonalMatrix.udiagIm[0] = -complex.imag();
            --n;
            for (int i = 1; i < n; ++i) {
                complex = abstractComplexSquareMatrix.getElement(i, i - 1);
                complexTridiagonalMatrix.ldiagRe[i] = -complex.real();
                complexTridiagonalMatrix.ldiagIm[i] = -complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i);
                complexTridiagonalMatrix.diagRe[i] = this.diagRe[i] - complex.real();
                complexTridiagonalMatrix.diagIm[i] = this.diagIm[i] - complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i + 1);
                complexTridiagonalMatrix.udiagRe[i] = -complex.real();
                complexTridiagonalMatrix.udiagIm[i] = -complex.imag();
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = -complex.real();
            complexTridiagonalMatrix.ldiagIm[n] = -complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] - complex.real();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] - complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix subtract(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.numRows == complexDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] - complexDiagonalMatrix.diagRe[0];
            dArray2[0] = this.diagIm[0] - complexDiagonalMatrix.diagIm[0];
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diagRe[i] - complexDiagonalMatrix.diagRe[i];
                dArray2[i] = this.diagIm[i] - complexDiagonalMatrix.diagIm[i];
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        dArray[0] = d * this.diagRe[0] - d2 * this.diagIm[0];
        dArray2[0] = d2 * this.diagRe[0] + d * this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = d * this.diagRe[i] - d2 * this.diagIm[i];
            dArray2[i] = d2 * this.diagRe[i] + d * this.diagIm[i];
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        dArray[0] = d * this.diagRe[0];
        dArray2[0] = d * this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = d * this.diagRe[i];
            dArray2[i] = d * this.diagIm[i];
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public AbstractComplexVector multiply(AbstractComplexVector abstractComplexVector) {
        if (this.numCols == abstractComplexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            Complex complex = abstractComplexVector.getComponent(0);
            dArray[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            dArray2[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            for (int i = 1; i < this.numRows; ++i) {
                complex = abstractComplexVector.getComponent(i);
                dArray[i] = this.diagRe[i] * complex.real() - this.diagIm[i] * complex.imag();
                dArray2[i] = this.diagIm[i] * complex.real() + this.diagRe[i] * complex.imag();
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractComplexSquareMatrix);
        }
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][abstractComplexSquareMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][abstractComplexSquareMatrix.columns()];
            for (int i = 0; i < this.numRows; ++i) {
                Complex complex = abstractComplexSquareMatrix.getElement(i, 0);
                dArray[i][0] = this.diagRe[i] * complex.real() - this.diagIm[i] * complex.imag();
                dArray2[i][0] = this.diagIm[i] * complex.real() + this.diagRe[i] * complex.imag();
                for (int j = 1; j < abstractComplexSquareMatrix.columns(); ++j) {
                    complex = abstractComplexSquareMatrix.getElement(i, j);
                    dArray[i][j] = this.diagRe[i] * complex.real() - this.diagIm[i] * complex.imag();
                    dArray2[i][j] = this.diagIm[i] * complex.real() + this.diagRe[i] * complex.imag();
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numCols == complexSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.diagRe[i] * complexSquareMatrix.matrixRe[i][0] - this.diagIm[i] * complexSquareMatrix.matrixIm[i][0];
                dArray2[i][0] = this.diagIm[i] * complexSquareMatrix.matrixRe[i][0] + this.diagRe[i] * complexSquareMatrix.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.diagRe[i] * complexSquareMatrix.matrixRe[i][j] - this.diagIm[i] * complexSquareMatrix.matrixIm[i][j];
                    dArray2[i][j] = this.diagIm[i] * complexSquareMatrix.matrixRe[i][j] + this.diagRe[i] * complexSquareMatrix.matrixIm[i][j];
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == complexTridiagonalMatrix.numRows) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.diagRe[0] = this.diagRe[0] * complexTridiagonalMatrix.diagRe[0] - this.diagIm[0] * complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.diagIm[0] = this.diagIm[0] * complexTridiagonalMatrix.diagRe[0] + this.diagRe[0] * complexTridiagonalMatrix.diagIm[0];
            complexTridiagonalMatrix2.udiagRe[0] = this.diagRe[0] * complexTridiagonalMatrix.udiagRe[0] - this.diagIm[0] * complexTridiagonalMatrix.udiagIm[0];
            complexTridiagonalMatrix2.udiagIm[0] = this.diagIm[0] * complexTridiagonalMatrix.udiagRe[0] + this.diagRe[0] * complexTridiagonalMatrix.udiagIm[0];
            --n;
            for (int i = 1; i < n; ++i) {
                complexTridiagonalMatrix2.ldiagRe[i] = this.diagRe[i] * complexTridiagonalMatrix.ldiagRe[i] - this.diagIm[i] * complexTridiagonalMatrix.ldiagIm[i];
                complexTridiagonalMatrix2.ldiagIm[i] = this.diagIm[i] * complexTridiagonalMatrix.ldiagRe[i] + this.diagRe[i] * complexTridiagonalMatrix.ldiagIm[i];
                complexTridiagonalMatrix2.diagRe[i] = this.diagRe[i] * complexTridiagonalMatrix.diagRe[i] - this.diagIm[i] * complexTridiagonalMatrix.diagIm[i];
                complexTridiagonalMatrix2.diagIm[i] = this.diagIm[i] * complexTridiagonalMatrix.diagRe[i] + this.diagRe[i] * complexTridiagonalMatrix.diagIm[i];
                complexTridiagonalMatrix2.udiagRe[i] = this.diagRe[i] * complexTridiagonalMatrix.udiagRe[i] - this.diagIm[i] * complexTridiagonalMatrix.udiagIm[i];
                complexTridiagonalMatrix2.udiagIm[i] = this.diagIm[i] * complexTridiagonalMatrix.udiagRe[i] + this.diagRe[i] * complexTridiagonalMatrix.udiagIm[i];
            }
            complexTridiagonalMatrix2.ldiagRe[n] = this.diagRe[n] * complexTridiagonalMatrix.ldiagRe[n] - this.diagIm[n] * complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.ldiagIm[n] = this.diagIm[n] * complexTridiagonalMatrix.ldiagRe[n] + this.diagRe[n] * complexTridiagonalMatrix.ldiagIm[n];
            complexTridiagonalMatrix2.diagRe[n] = this.diagRe[n] * complexTridiagonalMatrix.diagRe[n] - this.diagIm[n] * complexTridiagonalMatrix.diagIm[n];
            complexTridiagonalMatrix2.diagIm[n] = this.diagIm[n] * complexTridiagonalMatrix.diagRe[n] + this.diagRe[n] * complexTridiagonalMatrix.diagIm[n];
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix multiplyTridiagonal(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            Complex complex = abstractComplexSquareMatrix.getElement(0, 0);
            complexTridiagonalMatrix.diagRe[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            complexTridiagonalMatrix.diagIm[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            complex = abstractComplexSquareMatrix.getElement(0, 1);
            complexTridiagonalMatrix.udiagRe[0] = this.diagRe[0] * complex.real() - this.diagIm[0] * complex.imag();
            complexTridiagonalMatrix.udiagIm[0] = this.diagIm[0] * complex.real() + this.diagRe[0] * complex.imag();
            --n;
            for (int i = 1; i < n; ++i) {
                complex = abstractComplexSquareMatrix.getElement(i, i - 1);
                complexTridiagonalMatrix.ldiagRe[i] = this.diagRe[i] * complex.real() - this.diagIm[i] * complex.imag();
                complexTridiagonalMatrix.ldiagIm[i] = this.diagIm[i] * complex.real() + this.diagRe[i] * complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i);
                complexTridiagonalMatrix.diagRe[i] = this.diagRe[i] * complex.real() - this.diagIm[i] * complex.imag();
                complexTridiagonalMatrix.diagIm[i] = this.diagIm[i] * complex.real() + this.diagRe[i] * complex.imag();
                complex = abstractComplexSquareMatrix.getElement(i, i + 1);
                complexTridiagonalMatrix.udiagRe[i] = this.diagRe[i] * complex.real() - this.diagIm[i] * complex.imag();
                complexTridiagonalMatrix.udiagIm[i] = this.diagIm[i] * complex.real() + this.diagRe[i] * complex.imag();
            }
            complex = abstractComplexSquareMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix.ldiagRe[n] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
            complexTridiagonalMatrix.ldiagIm[n] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
            complex = abstractComplexSquareMatrix.getElement(n, n);
            complexTridiagonalMatrix.diagRe[n] = this.diagRe[n] * complex.real() - this.diagIm[n] * complex.imag();
            complexTridiagonalMatrix.diagIm[n] = this.diagIm[n] * complex.real() + this.diagRe[n] * complex.imag();
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix multiply(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.numCols == complexDiagonalMatrix.numRows) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            dArray[0] = this.diagRe[0] * complexDiagonalMatrix.diagRe[0] - this.diagIm[0] * complexDiagonalMatrix.diagIm[0];
            dArray2[0] = this.diagIm[0] * complexDiagonalMatrix.diagRe[0] + this.diagRe[0] * complexDiagonalMatrix.diagIm[0];
            for (int i = 1; i < this.numRows; ++i) {
                dArray[i] = this.diagRe[i] * complexDiagonalMatrix.diagRe[i] - this.diagIm[i] * complexDiagonalMatrix.diagIm[i];
                dArray2[i] = this.diagIm[i] * complexDiagonalMatrix.diagRe[i] + this.diagRe[i] * complexDiagonalMatrix.diagIm[i];
            }
            return new ComplexDiagonalMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix inverse() {
        double[] dArray = new double[this.numRows];
        double[] dArray2 = new double[this.numRows];
        double d = this.diagRe[0] * this.diagRe[0] + this.diagIm[0] * this.diagIm[0];
        dArray[0] = this.diagRe[0] / d;
        dArray2[0] = -this.diagIm[0] / d;
        for (int i = 1; i < this.numRows; ++i) {
            d = this.diagRe[i] * this.diagRe[i] + this.diagIm[i] * this.diagIm[i];
            dArray[i] = this.diagRe[i] / d;
            dArray2[i] = -this.diagIm[i] / d;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        return this.conjugate();
    }

    public AbstractComplexMatrix conjugate() {
        double[] dArray = new double[this.numRows];
        dArray[0] = -this.diagIm[0];
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = -this.diagIm[i];
        }
        return new ComplexDiagonalMatrix(this.diagRe, dArray);
    }

    public Matrix transpose() {
        return this;
    }

    public AbstractComplexSquareMatrix[] luDecompose(int[] nArray) {
        AbstractComplexSquareMatrix[] abstractComplexSquareMatrixArray = this.luDecompose_cache(nArray);
        if (abstractComplexSquareMatrixArray != null) {
            return abstractComplexSquareMatrixArray;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        for (int i = 0; i < this.numRows; ++i) {
            nArray[i] = i;
        }
        nArray[this.numRows] = 1;
        ComplexDiagonalMatrix complexDiagonalMatrix = ComplexDiagonalMatrix.identity(this.numRows);
        ComplexDiagonalMatrix complexDiagonalMatrix2 = this;
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.luCache = new ComplexLUCache(complexDiagonalMatrix, complexDiagonalMatrix2, nArray2);
        return new ComplexDiagonalMatrix[]{complexDiagonalMatrix, complexDiagonalMatrix2};
    }

    public AbstractComplexSquareMatrix[] luDecompose() {
        return this.luDecompose(null);
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex complex = complexMapping.map(Complex.ZERO);
        if (complex.mod() <= GlobalSettings.ZERO_TOL) {
            return this.diagonalMap(complexMapping);
        }
        return this.generalMap(complexMapping, complex);
    }

    private AbstractComplexMatrix diagonalMap(ComplexMapping complexMapping) {
        Complex[] complexArray = new Complex[this.numRows];
        complexArray[0] = complexMapping.map(this.diagRe[0], this.diagIm[0]);
        for (int i = 1; i < this.numRows; ++i) {
            complexArray[i] = complexMapping.map(this.diagRe[i], this.diagIm[i]);
        }
        return new ComplexDiagonalMatrix(complexArray);
    }

    private AbstractComplexMatrix generalMap(ComplexMapping complexMapping, Complex complex) {
        int n;
        double[][] dArray = new double[this.numRows][this.numRows];
        double[][] dArray2 = new double[this.numRows][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            for (n = 0; n < this.numRows; ++n) {
                dArray[i][n] = complex.real();
                dArray2[i][n] = complex.imag();
            }
        }
        Complex complex2 = complexMapping.map(this.diagRe[0], this.diagIm[0]);
        dArray[0][0] = complex2.real();
        dArray2[0][0] = complex2.imag();
        for (n = 1; n < this.numRows; ++n) {
            complex2 = complexMapping.map(this.diagRe[n], this.diagIm[n]);
            dArray[n][n] = complex2.real();
            dArray2[n][n] = complex2.imag();
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }
}

