/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.polynomials.ComplexPolynomialRing;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialMath;

public class ComplexPolynomial
implements Polynomial {
    private Complex[] _coeff;

    public ComplexPolynomial(Complex[] complexArray) {
        if (complexArray == null) {
            throw new NullPointerException("Coefficients cannot be null");
        }
        this._coeff = ComplexPolynomial.normalise(complexArray);
    }

    private static Complex[] normalise(Complex[] complexArray) {
        int n;
        for (n = complexArray.length - 1; n >= 0 && complexArray[n].norm() <= 2.0 * GlobalSettings.ZERO_TOL; --n) {
        }
        if (n < 0) {
            return new Complex[]{Complex.ZERO};
        }
        if (n < complexArray.length - 1) {
            Complex[] complexArray2 = new Complex[n + 1];
            System.arraycopy(complexArray, 0, complexArray2, 0, complexArray2.length);
            return complexArray2;
        }
        return complexArray;
    }

    public ComplexPolynomial(Field.Member[] memberArray) {
        this._coeff = ComplexPolynomial.normalise(ComplexPolynomialRing.toComplex(memberArray));
    }

    public Field.Member getCoefficient(int n) {
        return this.getCoefficientAsComplex(n);
    }

    public Complex getCoefficientAsComplex(int n) {
        if (n >= this._coeff.length) {
            return Complex.ZERO;
        }
        return this._coeff[n];
    }

    public Field.Member[] getCoefficients() {
        return this.getCoefficientsAsComplexes();
    }

    public Complex[] getCoefficientsAsComplexes() {
        return this._coeff;
    }

    public Complex map(Complex complex) {
        return PolynomialMath.evalPolynomial(this, complex);
    }

    public Complex map(double d, double d2) {
        return this.map(new Complex(d, d2));
    }

    public int degree() {
        return this._coeff.length - 1;
    }

    public Object getSet() {
        return ComplexPolynomialRing.getInstance();
    }

    public boolean isZero() {
        for (int i = 0; i < this._coeff.length; ++i) {
            if (!(this._coeff[i].norm() > GlobalSettings.ZERO_TOL * 2.0)) continue;
            return false;
        }
        return true;
    }

    public boolean isOne() {
        if (this._coeff[0].subtract(Complex.ONE).norm() > GlobalSettings.ZERO_TOL * 2.0) {
            return false;
        }
        for (int i = 1; i < this._coeff.length; ++i) {
            if (!(this._coeff[i].norm() > 2.0 * GlobalSettings.ZERO_TOL)) continue;
            return false;
        }
        return true;
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        Complex[] complexArray;
        ComplexPolynomial complexPolynomial = null;
        if (member instanceof ComplexPolynomial) {
            ComplexPolynomial complexPolynomial2 = (ComplexPolynomial)member;
            int n = PolynomialMath.maxDegree(this, complexPolynomial2);
            complexArray = new Complex[n + 1];
            for (int i = 0; i < complexArray.length; ++i) {
                complexArray[i] = this.getCoefficientAsComplex(i).add(complexPolynomial2.getCoefficientAsComplex(i));
            }
        } else {
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }
        complexPolynomial = new ComplexPolynomial(complexArray);
        return complexPolynomial;
    }

    public Polynomial scalarDivide(Field.Member member) {
        if (member instanceof Complex) {
            return this.scalarDivide((Complex)member);
        }
        if (member instanceof Number) {
            return this.scalarDivide(((Number)((Object)member)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexPolynomial scalarDivide(Complex complex) {
        Complex[] complexArray = new Complex[this._coeff.length];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray[i] = this._coeff[i].divide(complex);
        }
        return new ComplexPolynomial(complexArray);
    }

    public ComplexPolynomial scalarDivide(double d) {
        Complex[] complexArray = new Complex[this._coeff.length];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray[i] = this._coeff[i].divide(d);
        }
        return new ComplexPolynomial(complexArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ComplexPolynomial) {
            ComplexPolynomial complexPolynomial = (ComplexPolynomial)object;
            int n = PolynomialMath.maxDegree(this, complexPolynomial);
            for (int i = 0; i <= n; ++i) {
                if (!(complexPolynomial.getCoefficientAsComplex(i).subtract(this.getCoefficientAsComplex(i)).norm() > 2.0 * GlobalSettings.ZERO_TOL)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._coeff.length; ++i) {
            n += (int)(this._coeff[i].norm() * 10.0);
        }
        return n;
    }

    public Polynomial scalarMultiply(Field.Member member) {
        if (member instanceof Number) {
            double d = ((Number)((Object)member)).doubleValue();
            return this.scalarMultiply(d);
        }
        if (member instanceof Complex) {
            return this.scalarMultiply((Complex)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexPolynomial scalarMultiply(double d) {
        Complex[] complexArray = new Complex[this._coeff.length];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray[i] = this._coeff[i].multiply(d);
        }
        return new ComplexPolynomial(complexArray);
    }

    public ComplexPolynomial scalarMultiply(Complex complex) {
        Complex[] complexArray = new Complex[this._coeff.length];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray[i] = this._coeff[i].multiply(complex);
        }
        return new ComplexPolynomial(complexArray);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof ComplexPolynomial) {
            int n;
            ComplexPolynomial complexPolynomial = (ComplexPolynomial)member;
            int n2 = PolynomialMath.maxDegree(this, complexPolynomial);
            int n3 = PolynomialMath.minDegree(this, complexPolynomial);
            int n4 = n2 + n3;
            Complex[] complexArray = new Complex[n4 + 1];
            for (n = 0; n < complexArray.length; ++n) {
                complexArray[n] = Complex.ZERO;
            }
            for (n = 0; n < this._coeff.length; ++n) {
                Complex complex = this._coeff[n];
                for (int i = 0; i < complexPolynomial._coeff.length; ++i) {
                    Complex complex2 = complexPolynomial._coeff[i];
                    complexArray[n + i] = complexArray[n + i].add(complex.multiply(complex2));
                }
            }
            return new ComplexPolynomial(complexArray);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbelianGroup.Member negate() {
        Complex[] complexArray = new Complex[this._coeff.length];
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray[i] = (Complex)this._coeff[i].negate();
        }
        return new ComplexPolynomial(complexArray);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof ComplexPolynomial) {
            ComplexPolynomial complexPolynomial = (ComplexPolynomial)member;
            int n = PolynomialMath.maxDegree(this, complexPolynomial);
            Complex[] complexArray = new Complex[n + 1];
            for (int i = 0; i < complexArray.length; ++i) {
                complexArray[i] = this.getCoefficientAsComplex(i).subtract(complexPolynomial.getCoefficientAsComplex(i));
            }
            return new ComplexPolynomial(complexArray);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("P(z) = ");
        for (int i = this.degree(); i > 0; --i) {
            stringBuffer.append(this._coeff[i]).append("z^").append(i).append(" + ");
        }
        stringBuffer.append(this._coeff[0]);
        return stringBuffer.toString();
    }
}

