/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiMuonNeutrino;
import JSci.physics.particles.Lepton;
import JSci.physics.particles.Muon;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class MuonNeutrino
extends Lepton {
    public double restMass() {
        return 0.0;
    }

    public int charge() {
        return 0;
    }

    public int eLeptonQN() {
        return 0;
    }

    public int muLeptonQN() {
        return 1;
    }

    public int tauLeptonQN() {
        return 0;
    }

    public QuantumParticle anti() {
        return new AntiMuonNeutrino();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof AntiMuonNeutrino;
    }

    public String toString() {
        return new String("Muon neutrino");
    }

    public Muon emit(WPlus wPlus) {
        Muon muon = new Muon();
        muon.momentum = this.momentum.subtract(wPlus.momentum);
        return muon;
    }

    public Muon absorb(WMinus wMinus) {
        Muon muon = new Muon();
        muon.momentum = this.momentum.add(wMinus.momentum);
        return muon;
    }

    public MuonNeutrino emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public MuonNeutrino absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

