/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.DoubleBarrelLRUCache;

final class TermInfosReader {
    private final Directory directory;
    private final String segment;
    private final FieldInfos fieldInfos;
    private final CloseableThreadLocal<ThreadResources> threadResources = new CloseableThreadLocal();
    private final SegmentTermEnum origEnum;
    private final long size;
    private final Term[] indexTerms;
    private final TermInfo[] indexInfos;
    private final long[] indexPointers;
    private final int totalIndexInterval;
    private static final int DEFAULT_CACHE_SIZE = 1024;
    private final DoubleBarrelLRUCache<CloneableTerm, TermInfoAndOrd> termsCache = new DoubleBarrelLRUCache(1024);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TermInfosReader(Directory dir, String seg, FieldInfos fis, int readBufferSize, int indexDivisor) throws CorruptIndexException, IOException {
        boolean success = false;
        if (indexDivisor < 1 && indexDivisor != -1) {
            throw new IllegalArgumentException("indexDivisor must be -1 (don't load terms index) or greater than 0: got " + indexDivisor);
        }
        try {
            block8: {
                this.directory = dir;
                this.segment = seg;
                this.fieldInfos = fis;
                this.origEnum = new SegmentTermEnum(this.directory.openInput(IndexFileNames.segmentFileName(this.segment, "tis"), readBufferSize), this.fieldInfos, false);
                this.size = this.origEnum.size;
                if (indexDivisor != -1) {
                    this.totalIndexInterval = this.origEnum.indexInterval * indexDivisor;
                    SegmentTermEnum indexEnum = new SegmentTermEnum(this.directory.openInput(IndexFileNames.segmentFileName(this.segment, "tii"), readBufferSize), this.fieldInfos, true);
                    try {
                        int indexSize = 1 + ((int)indexEnum.size - 1) / indexDivisor;
                        this.indexTerms = new Term[indexSize];
                        this.indexInfos = new TermInfo[indexSize];
                        this.indexPointers = new long[indexSize];
                        int i = 0;
                        while (indexEnum.next()) {
                            this.indexTerms[i] = indexEnum.term();
                            this.indexInfos[i] = indexEnum.termInfo();
                            this.indexPointers[i] = indexEnum.indexPointer;
                            for (int j = 1; j < indexDivisor && indexEnum.next(); ++j) {
                            }
                            ++i;
                        }
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        indexEnum.close();
                        throw throwable;
                    }
                    indexEnum.close();
                    {
                        break block8;
                    }
                }
                this.totalIndexInterval = -1;
                this.indexTerms = null;
                this.indexInfos = null;
                this.indexPointers = null;
            }
            success = true;
            Object var14_14 = null;
            if (success) return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (success) throw throwable;
            this.close();
            throw throwable;
        }
        this.close();
    }

    public int getSkipInterval() {
        return this.origEnum.skipInterval;
    }

    public int getMaxSkipLevels() {
        return this.origEnum.maxSkipLevels;
    }

    final void close() throws IOException {
        if (this.origEnum != null) {
            this.origEnum.close();
        }
        this.threadResources.close();
    }

    final long size() {
        return this.size;
    }

    private ThreadResources getThreadResources() {
        ThreadResources resources = this.threadResources.get();
        if (resources == null) {
            resources = new ThreadResources();
            resources.termEnum = this.terms();
            this.threadResources.set(resources);
        }
        return resources;
    }

    private final int getIndexOffset(Term term) {
        int lo = 0;
        int hi = this.indexTerms.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int delta = term.compareTo(this.indexTerms[mid]);
            if (delta < 0) {
                hi = mid - 1;
                continue;
            }
            if (delta > 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return hi;
    }

    private final void seekEnum(SegmentTermEnum enumerator, int indexOffset) throws IOException {
        enumerator.seek(this.indexPointers[indexOffset], (long)indexOffset * (long)this.totalIndexInterval - 1L, this.indexTerms[indexOffset], this.indexInfos[indexOffset]);
    }

    TermInfo get(Term term) throws IOException {
        return this.get(term, false);
    }

    private TermInfo get(Term term, boolean mustSeekEnum) throws IOException {
        TermInfo ti;
        int enumOffset;
        if (this.size == 0L) {
            return null;
        }
        this.ensureIndexIsRead();
        CloneableTerm cacheKey = new CloneableTerm(term);
        TermInfoAndOrd tiOrd = this.termsCache.get(cacheKey);
        ThreadResources resources = this.getThreadResources();
        if (!mustSeekEnum && tiOrd != null) {
            return tiOrd;
        }
        SegmentTermEnum enumerator = resources.termEnum;
        if (enumerator.term() != null && (enumerator.prev() != null && term.compareTo(enumerator.prev()) > 0 || term.compareTo(enumerator.term()) >= 0) && (this.indexTerms.length == (enumOffset = (int)(enumerator.position / (long)this.totalIndexInterval) + 1) || term.compareTo(this.indexTerms[enumOffset]) < 0)) {
            TermInfo ti2;
            int numScans = enumerator.scanTo(term);
            if (enumerator.term() != null && term.compareTo(enumerator.term()) == 0) {
                ti2 = enumerator.termInfo();
                if (numScans > 1) {
                    if (tiOrd == null) {
                        this.termsCache.put(cacheKey, new TermInfoAndOrd(ti2, enumerator.position));
                    } else {
                        assert (this.sameTermInfo(ti2, tiOrd, enumerator));
                        assert ((long)((int)enumerator.position) == tiOrd.termOrd);
                    }
                }
            } else {
                ti2 = null;
            }
            return ti2;
        }
        int indexPos = tiOrd != null ? (int)(tiOrd.termOrd / (long)this.totalIndexInterval) : this.getIndexOffset(term);
        this.seekEnum(enumerator, indexPos);
        enumerator.scanTo(term);
        if (enumerator.term() != null && term.compareTo(enumerator.term()) == 0) {
            ti = enumerator.termInfo();
            if (tiOrd == null) {
                if (enumerator.position >= 0L) {
                    this.termsCache.put(cacheKey, new TermInfoAndOrd(ti, enumerator.position));
                }
            } else {
                assert (this.sameTermInfo(ti, tiOrd, enumerator));
                assert (enumerator.position == tiOrd.termOrd);
            }
        } else {
            ti = null;
        }
        return ti;
    }

    private final boolean sameTermInfo(TermInfo ti1, TermInfo ti2, SegmentTermEnum enumerator) {
        if (ti1.docFreq != ti2.docFreq) {
            return false;
        }
        if (ti1.freqPointer != ti2.freqPointer) {
            return false;
        }
        if (ti1.proxPointer != ti2.proxPointer) {
            return false;
        }
        return ti1.docFreq < enumerator.skipInterval || ti1.skipOffset == ti2.skipOffset;
    }

    private void ensureIndexIsRead() {
        if (this.indexTerms == null) {
            throw new IllegalStateException("terms index was not loaded when this reader was created");
        }
    }

    final long getPosition(Term term) throws IOException {
        if (this.size == 0L) {
            return -1L;
        }
        this.ensureIndexIsRead();
        int indexOffset = this.getIndexOffset(term);
        SegmentTermEnum enumerator = this.getThreadResources().termEnum;
        this.seekEnum(enumerator, indexOffset);
        while (term.compareTo(enumerator.term()) > 0 && enumerator.next()) {
        }
        if (term.compareTo(enumerator.term()) == 0) {
            return enumerator.position;
        }
        return -1L;
    }

    public SegmentTermEnum terms() {
        return (SegmentTermEnum)this.origEnum.clone();
    }

    public SegmentTermEnum terms(Term term) throws IOException {
        this.get(term, true);
        return (SegmentTermEnum)this.getThreadResources().termEnum.clone();
    }

    private static final class ThreadResources {
        SegmentTermEnum termEnum;

        private ThreadResources() {
        }
    }

    private static class CloneableTerm
    extends DoubleBarrelLRUCache.CloneableKey {
        private final Term term;

        public CloneableTerm(Term t) {
            this.term = new Term(t.field(), t.text());
        }

        public Object clone() {
            return new CloneableTerm(this.term);
        }

        public boolean equals(Object _other) {
            CloneableTerm other = (CloneableTerm)_other;
            return this.term.equals(other.term);
        }

        public int hashCode() {
            return this.term.hashCode();
        }
    }

    private static final class TermInfoAndOrd
    extends TermInfo {
        final long termOrd;

        public TermInfoAndOrd(TermInfo ti, long termOrd) {
            super(ti);
            assert (termOrd >= 0L);
            this.termOrd = termOrd;
        }
    }
}

