/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.msa.Msa;
import org.forester.sequence.Sequence;
import org.forester.util.ForesterUtil;

public class BasicMsa
implements Msa {
    private final char[][] _data;
    private final Object[] _identifiers;
    private final Sequence.TYPE _type;

    public BasicMsa(int n, int n2, Sequence.TYPE tYPE) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("basic msa of size zero are illegal");
        }
        this._data = new char[n][n2];
        this._identifiers = new Object[n];
        this._type = tYPE;
    }

    BasicMsa(BasicMsa basicMsa) {
        this._data = basicMsa._data;
        this._identifiers = basicMsa._identifiers;
        this._type = basicMsa._type;
    }

    private int determineMaxIdLength() {
        int n = 0;
        for (int i = 0; i < this._data.length; ++i) {
            int n2 = this._identifiers[i].toString().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public Object getIdentifier(int n) {
        return this._identifiers[n];
    }

    @Override
    public int getLength() {
        return this._data[0].length;
    }

    @Override
    public int getNumberOfSequences() {
        return this._identifiers.length;
    }

    @Override
    public char getResidueAt(int n, int n2) {
        return this._data[n][n2];
    }

    @Override
    public StringBuffer getSequenceAsString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this._data[0].length);
        for (int i = 0; i < this._data[0].length; ++i) {
            stringBuffer.append(this.getResidueAt(n, i));
        }
        return stringBuffer;
    }

    @Override
    public Sequence.TYPE getType() {
        return this._type;
    }

    @Override
    public void setIdentifier(int n, Object object) {
        this._identifiers[n] = object;
    }

    @Override
    public void setResidueAt(int n, int n2, char c) {
        this._data[n][n2] = c;
    }

    public String toString() {
        int n = this.determineMaxIdLength() + 1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._data.length; ++i) {
            stringBuffer.append(ForesterUtil.pad(this._identifiers[i].toString(), n, ' ', false));
            for (int j = 0; j < this._data[0].length; ++j) {
                stringBuffer.append(this.getResidueAt(i, j));
            }
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    @Override
    public void write(Writer writer) throws IOException {
        int n = this.determineMaxIdLength() + 1;
        for (int i = 0; i < this._data.length; ++i) {
            writer.write(ForesterUtil.pad(this._identifiers[i].toString(), n, ' ', false).toString());
            for (int j = 0; j < this._data[0].length; ++j) {
                writer.write(this.getResidueAt(i, j));
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    public static Msa createInstance(List<Sequence> list) {
        if (list.size() < 1) {
            throw new IllegalArgumentException("cannot create basic msa from less than one sequence");
        }
        int n = list.get(0).getLength();
        BasicMsa basicMsa = new BasicMsa(list.size(), n, list.get(0).getType());
        for (int i = 0; i < list.size(); ++i) {
            Sequence sequence = list.get(i);
            if (sequence.getLength() != n) {
                throw new IllegalArgumentException("illegal attempt to build msa from sequences of unequal length");
            }
            if (sequence.getType() != basicMsa.getType()) {
                throw new IllegalArgumentException("illegal attempt to build msa from sequences of different type");
            }
            basicMsa.setIdentifier(i, sequence.getIdentifier());
            for (int j = 0; j < n; ++j) {
                basicMsa._data[i][j] = sequence.getResidueAt(j);
            }
        }
        return basicMsa;
    }

    @Override
    public List<Character> getColumnAt(int n) {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            arrayList.add(Character.valueOf(this.getResidueAt(i, n)));
        }
        return arrayList;
    }
}

