/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.forester.io.parsers.FastaParser;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.util.ExternalProgram;
import org.forester.util.ForesterUtil;

public final class MafftOLD
implements MsaInferrer {
    private String _error;
    private int _exit_code;
    private final String _path_to_prg;

    public static MsaInferrer createInstance(String string) {
        return new MafftOLD(string);
    }

    private MafftOLD(String string) {
        this._path_to_prg = new String(string);
        this.init();
    }

    public Object clone() {
        throw new NoSuchMethodError();
    }

    @Override
    public String getErrorDescription() {
        return this._error;
    }

    @Override
    public int getExitCode() {
        return this._exit_code;
    }

    @Override
    public Msa infer(File file, List<String> list) throws IOException, InterruptedException {
        this.init();
        String[] stringArray = new String[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i);
        }
        stringArray[list.size()] = file.getAbsolutePath();
        ExternalProgram externalProgram = new ExternalProgram(this._path_to_prg);
        externalProgram.launch(stringArray);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(externalProgram.getErrorStream()));
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        bufferedReader.close();
        if (stringBuffer.length() > 0) {
            this._error = stringBuffer.toString();
            throw new IOException("MAFFT failed");
        }
        InputStream inputStream = externalProgram.getInputStream();
        Msa msa = FastaParser.parseMsa(inputStream);
        inputStream.close();
        return msa;
    }

    private void init() {
        this._error = null;
        this._exit_code = -100;
    }
}

