/*
 * Decompiled with CFR 0.152.
 */
package briefj.db;

import briefj.db.SqlKeywords;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Records {
    public static final String FOLDER_LOCATION_COLUMN = "folder_location";
    public static final String TIME_STAMP_COLUMN_NAME = "time_stamp";
    public static final String ID_COLUMN_NAME = "id";
    public static final String databaseTableName = "run";
    public final Connection conn;
    private final File dbFile;
    private boolean _tableCreationChecked = false;
    private Set<String> _variables = null;

    public static Records recordsFromEnvironmentVariable() {
        File dbFile = new File(System.getenv().get("CONN_PATH"), "index.db");
        return new Records(dbFile);
    }

    public Records(File dbFile) {
        this.conn = this.connect(dbFile);
        this.dbFile = dbFile;
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void recordFullRun(LinkedHashMap<String, String> options, LinkedHashMap<String, String> output, File execDir) {
        LinkedHashMap keyValuePairs = Maps.newLinkedHashMap();
        if (options != null) {
            keyValuePairs.putAll(options);
        }
        if (output != null) {
            keyValuePairs.putAll(output);
        }
        if (execDir != null) {
            keyValuePairs.put(FOLDER_LOCATION_COLUMN, execDir.toString());
        }
        this.record(keyValuePairs);
    }

    public void recordFullRun(LinkedHashMap<String, String> options, File resultDirectory) {
        this.recordFullRun(options, null, resultDirectory);
    }

    public void record(LinkedHashMap<String, String> keyValuePairs) {
        this.ensureTableCreated();
        this.insertInto(keyValuePairs);
    }

    public static LinkedHashMap<String, String> cleanColumnNames(Map<String, String> datum) {
        LinkedHashMap<String, String> clean = new LinkedHashMap<String, String>();
        for (String columnName : datum.keySet()) {
            clean.put(Records.cleanColumnName(columnName), datum.get(columnName));
        }
        if (datum.keySet().size() != clean.keySet().size()) {
            throw new RuntimeException("Cleaning sql table names created a clash. \nBefore: " + datum + "\nAfter: " + clean);
        }
        return clean;
    }

    public Set<String> recordedExecFolders() {
        try {
            HashSet result = Sets.newHashSet();
            Statement stmt = this.conn.createStatement();
            String sql = "SELECT folder_location FROM run";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String last = rs.getString(FOLDER_LOCATION_COLUMN);
                result.add(last);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String cleanColumnName(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char current = string.charAt(i);
            if (current >= 'a' && current <= 'z') {
                result.append(current);
                continue;
            }
            if (current >= 'A' && current <= 'Z') {
                if (i > 0 && string.charAt(i - 1) >= 'a' && string.charAt(i - 1) <= 'z') {
                    result.append("_");
                }
                result.append(Character.toLowerCase(current));
                continue;
            }
            result.append("_");
        }
        if (SqlKeywords.keywords.contains(result.toString())) {
            return "_" + result;
        }
        return result.toString();
    }

    private void alterTable(String newCol) {
        this._variables = null;
        StringBuilder str = new StringBuilder();
        str.append("ALTER TABLE ");
        str.append(databaseTableName);
        str.append(" ADD column ");
        str.append(newCol);
        str.append(" string DEFAULT NULL");
        try {
            Statement statement = this.conn.createStatement();
            statement.execute(str.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void insertInto(Map<String, String> _keyValuePairs) {
        int n2Input;
        LinkedHashMap<String, String> keyValuePairs = Records.cleanColumnNames(_keyValuePairs);
        Set<String> variables = this.getCurrentCols();
        int nRecorded = variables.size();
        if (nRecorded != (n2Input = keyValuePairs.size() + 2)) {
            HashSet addCols = Sets.newHashSet(keyValuePairs.keySet());
            addCols.removeAll(variables);
            for (String newCol : addCols) {
                this.alterTable(newCol);
            }
        }
        StringBuilder colNames = new StringBuilder();
        StringBuilder values = new StringBuilder();
        colNames.append(" (");
        values.append(" (");
        Records.insertStatement(keyValuePairs, colNames, values);
        colNames.append(")");
        values.append(")");
        String insert = null;
        try {
            Statement statement = this.conn.createStatement();
            insert = "INSERT INTO run" + colNames + " VALUES" + values;
            statement.execute(insert);
            statement.close();
        }
        catch (SQLException e) {
            System.out.println("Bad query: " + insert);
            throw new RuntimeException(e);
        }
    }

    private void ensureTableCreated() {
        if (this._tableCreationChecked) {
            return;
        }
        StringBuilder colNames = new StringBuilder();
        String createTable = "CREATE TABLE IF NOT EXISTS run (id INTEGER PRIMARY KEY AUTOINCREMENT, time_stamp DATETIME DEFAULT CURRENT_TIMESTAMP)";
        try {
            Statement statement = this.conn.createStatement();
            statement.execute(createTable + colNames.toString());
            statement.close();
            this._tableCreationChecked = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void insertStatement(LinkedHashMap<String, String> map, StringBuilder strNames, StringBuilder strValues) {
        if (map.isEmpty()) {
            return;
        }
        for (String key : map.keySet()) {
            strNames.append(key + ", ");
            if (map.get(key) == null) {
                strValues.append("NULL, ");
                continue;
            }
            strValues.append("'" + map.get(key).replace("'", "''") + "', ");
        }
        strNames.deleteCharAt(strNames.lastIndexOf(","));
        strValues.deleteCharAt(strValues.lastIndexOf(","));
    }

    public ResultSet select(String entries, String constraint) {
        String query = "";
        try {
            Statement statement = this.conn.createStatement();
            query = "SELECT " + entries + " FROM " + databaseTableName + (StringUtils.isEmpty((CharSequence)constraint) ? "" : " WHERE " + constraint);
            return statement.executeQuery(query);
        }
        catch (SQLException e) {
            throw new RuntimeException("Problematic query: " + query + "\nDetails:\n" + e);
        }
    }

    public Set<String> getCurrentCols() {
        if (this._variables != null) {
            return this._variables;
        }
        this._variables = new HashSet<String>();
        try {
            Statement statement = this.conn.createStatement();
            ResultSet res = statement.executeQuery("pragma table_info(run)");
            while (res.next()) {
                this._variables.add(res.getString("name"));
            }
            res.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this._variables;
    }

    private Connection connect(File databaseFile) {
        try {
            Class.forName("org.sqlite.JDBC");
            return DriverManager.getConnection("jdbc:sqlite:/" + databaseFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public File getDbFile() {
        return this.dbFile;
    }
}

