/*
 * Decompiled with CFR 0.152.
 */
package briefj.opt;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrUtils {
    public static String[] split(String s) {
        return StrUtils.split(s, " ");
    }

    public static String[] split(String s, String delim) {
        return StrUtils.isEmpty(s) ? new String[]{} : s.split(delim);
    }

    public static List<String> splitByStr(String s, String delim) {
        int j;
        if (StrUtils.isEmpty(s)) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int i = 0;
        while (i < s.length() && (j = s.indexOf(delim, i)) != -1) {
            tokens.add(s.substring(i, j));
            i = j + delim.length();
        }
        tokens.add(s.substring(i));
        return tokens;
    }

    public static int indexOfIgnoreEscaped(String s, char c) {
        return StrUtils.indexOfIgnoreEscaped(s, c, 0);
    }

    public static int indexOfIgnoreEscaped(String s, char c, int i) {
        return StrUtils.indexOfIgnoreEscaped(s, "" + c, i);
    }

    public static int indexOfIgnoreEscaped(String s, String cs, int i) {
        boolean escape = false;
        while (i < s.length()) {
            if (escape) {
                escape = false;
            } else if (s.charAt(i) == '\\') {
                escape = true;
            } else if (cs.indexOf(s.charAt(i)) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<String> splitIgnoreEscaped(String line, String delim) {
        String[] tokens = StrUtils.split(line, delim);
        ArrayList<String> newTokens = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].endsWith("\\") && i + 1 < tokens.length) {
                tokens[i + 1] = tokens[i].substring(0, tokens[i].length() - 1) + "\\" + delim + tokens[i + 1];
                continue;
            }
            newTokens.add(tokens[i]);
        }
        return newTokens;
    }

    public static double[] doubleSplit(String s, String delim) {
        String[] tokens = StrUtils.split(s, delim);
        double[] data = new double[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            data[i] = Double.parseDouble(tokens[i]);
        }
        return data;
    }

    public static double[] doubleSplit(String s) {
        return StrUtils.doubleSplit(s, " ");
    }

    public static int[] intSplit(String s, String delim) {
        String[] tokens = StrUtils.split(s, delim);
        int[] data = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            data[i] = Integer.parseInt(tokens[i]);
        }
        return data;
    }

    public static int[] intSplit(String s) {
        return StrUtils.intSplit(s, " ");
    }

    public static short[] shortSplit(String s, String delim) {
        String[] tokens = StrUtils.split(s, delim);
        short[] data = new short[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            data[i] = Short.parseShort(tokens[i]);
        }
        return data;
    }

    public static short[] shortSplit(String s) {
        return StrUtils.shortSplit(s, " ");
    }

    public static List<Integer> intSplitList(String s, String delim) {
        String[] tokens = StrUtils.split(s, delim);
        ArrayList<Integer> data = new ArrayList<Integer>(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            data.add(Integer.parseInt(tokens[i]));
        }
        return data;
    }

    public static List<Integer> intSplitList(String s) {
        return StrUtils.intSplitList(s, " ");
    }

    public static Map<String, String> parseHashMap(String line, String keyValueDelim) {
        return StrUtils.parseHashMap(line, keyValueDelim, " ");
    }

    public static Map<String, String> parseHashMap(String line, String keyValueDelim, String entryDelim) {
        return StrUtils.parseHashMap(Arrays.asList(StrUtils.split(line, entryDelim)), keyValueDelim);
    }

    public static Map<String, String> parseHashMap(List<String> tokens, String keyValueDelim) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String token : tokens) {
            String[] kv = token.split(keyValueDelim);
            if (kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public static <T> String join(double[] list) {
        return StrUtils.join(list, " ");
    }

    public static <T> String join(double[] list, String delim) {
        if (list == null) {
            return "";
        }
        ArrayList<Double> objs = new ArrayList<Double>();
        for (double x : list) {
            objs.add(x);
        }
        return StrUtils.join(objs, delim);
    }

    public static String join(int[] list) {
        return StrUtils.join(list, " ");
    }

    public static String join(int[] list, String delim) {
        if (list == null) {
            return "";
        }
        ArrayList<Integer> objs = new ArrayList<Integer>();
        for (int x : list) {
            objs.add(x);
        }
        return StrUtils.join(objs, delim);
    }

    public static String join(boolean[] list) {
        return StrUtils.join(list, " ");
    }

    public static String join(boolean[] list, String delim) {
        if (list == null) {
            return "";
        }
        ArrayList<Boolean> objs = new ArrayList<Boolean>();
        for (boolean x : list) {
            objs.add(x);
        }
        return StrUtils.join(objs, delim);
    }

    public static <T> String join(T[] objs) {
        if (objs == null) {
            return "";
        }
        return StrUtils.join(Arrays.asList(objs), " ");
    }

    public static <T> String join(T[] objs, int start, int end) {
        if (objs == null) {
            return "";
        }
        return StrUtils.join(Arrays.asList(objs), " ", start, end);
    }

    public static <T> String join(List<T> objs) {
        return StrUtils.join(objs, " ");
    }

    public static <T> String join(T[] objs, String delim) {
        if (objs == null) {
            return "";
        }
        return StrUtils.join(Arrays.asList(objs), delim);
    }

    public static <T> String join(List<T> objs, String delim) {
        if (objs == null) {
            return "";
        }
        return StrUtils.join(objs, delim, 0, objs.size());
    }

    public static <T> String join(List<T> objs, String delim, int start, int end) {
        if (objs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = start; i < end; ++i) {
            if (!first) {
                sb.append(delim);
            }
            sb.append(objs.get(i));
            first = false;
        }
        return sb.toString();
    }

    public static <T> String join(Collection<T> objs, String delim) {
        if (objs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T x : objs) {
            if (!first) {
                sb.append(delim);
            }
            sb.append(x);
            first = false;
        }
        return sb.toString();
    }

    public static String join(int[] x, boolean withIndices, int magnitudeThreshold) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            if (Math.abs(x[i]) < magnitudeThreshold) continue;
            if (i > 0) {
                sb.append(' ');
            }
            if (withIndices) {
                sb.append(i + ":");
            }
            sb.append(x[i]);
        }
        return sb.toString();
    }

    public static String joinWithIndices(int[] x) {
        return StrUtils.join(x, true, 0);
    }

    public static String join(double[] x, boolean withIndices, double magnitudeThreshold) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            if (Math.abs(x[i]) < magnitudeThreshold) continue;
            if (i > 0) {
                sb.append(' ');
            }
            if (withIndices) {
                sb.append(i + ":");
            }
            sb.append(x[i]);
        }
        return sb.toString();
    }

    public static String joinWithIndices(double[] x) {
        return StrUtils.join(x, true, 0.0);
    }

    public static <T> String join(T[][] data, String[] rowNames, String[] colNames) {
        int r;
        int c;
        int r2;
        int r0 = colNames == null ? 0 : 1;
        int c0 = rowNames == null ? 0 : 1;
        int R = data.length;
        int C = data[0].length;
        String[][] mat = new String[R + r0][C + r0];
        for (r2 = 0; r2 < R; ++r2) {
            for (c = 0; c < C; ++c) {
                mat[r2 + r0][c + c0] = "" + data[r2][c];
            }
        }
        if (rowNames != null) {
            for (r2 = 0; r2 < R; ++r2) {
                mat[r2 + r0][0] = rowNames[r2];
            }
        }
        if (colNames != null) {
            for (int c2 = 0; c2 < C; ++c2) {
                mat[0][c2 + c0] = colNames[c2];
            }
        }
        int[] widths = new int[C + c0];
        for (c = 0; c < C + c0; ++c) {
            for (r = 0; r < R + r0; ++r) {
                if (mat[r][c] == null) {
                    mat[r][c] = "";
                }
                widths[c] = Math.max(widths[c], mat[r][c].length());
            }
        }
        StringBuilder buf = new StringBuilder();
        for (r = 0; r < R + r0; ++r) {
            for (int c3 = 0; c3 < C + c0; ++c3) {
                String fmt = "%-" + (widths[c3] + 1) + "s";
                buf.append(String.format(fmt, mat[r][c3]));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static String repeat(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static Matcher match(String pattern, String s) {
        return Pattern.compile(pattern).matcher(s);
    }

    public static String[] format(String fmt, Object ... is) {
        int n = Array.getLength(is[0]);
        String[] out = new String[n];
        for (int i = 0; i < n; ++i) {
            Object[] args = new Object[is.length];
            for (int j = 0; j < is.length; ++j) {
                args[j] = Array.get(is[j], i);
            }
            out[i] = String.format(fmt, args);
        }
        return out;
    }
}

