/*
 * Decompiled with CFR 0.152.
 */
package briefj.repo;

import binc.Command;
import briefj.BriefIO;
import briefj.repo.GitRepository;
import briefj.repo.VersionControlRepository;
import briefj.run.Commands;
import briefj.run.ExecutionInfoFiles;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.List;

public class RepositoryUtils {
    public static VersionControlRepository findRepository(File forThisFile) {
        return GitRepository.fromLocal(forThisFile);
    }

    public static boolean recordCodeVersion(Runnable runnable) {
        File classFile = RepositoryUtils.findSourceFile(runnable);
        if (classFile == null) {
            System.err.println("WARNING: Could not find class file (lanching from jar?)");
            return false;
        }
        VersionControlRepository repository = RepositoryUtils.findRepository(classFile);
        if (repository == null) {
            System.err.println("WARNING: Could not find source repository in parent directories of " + classFile);
            return false;
        }
        List<File> dirtyFiles = repository.dirtyFiles();
        if (!dirtyFiles.isEmpty()) {
            File dirtyFilesReport = ExecutionInfoFiles.getFile("code/dirty-files.txt");
            System.err.println("WARNING: There were files not up to date in the code repository (see " + dirtyFilesReport.getAbsolutePath() + ")");
            BriefIO.write(dirtyFilesReport, Joiner.on((char)'\n').join(dirtyFiles));
        }
        BriefIO.write(ExecutionInfoFiles.getFile("code/info.map"), RepositoryUtils.toString(repository));
        File scriptFile = ExecutionInfoFiles.getFile("code/clone-script.sh");
        BriefIO.write(scriptFile, repository.cloneScript());
        try {
            Command.call((Command)Commands.chmod.withArgs("755").appendArg(scriptFile.getAbsolutePath()));
        }
        catch (Exception e) {
            // empty catch block
        }
        return dirtyFiles.isEmpty();
    }

    private static CharSequence toString(VersionControlRepository repository) {
        StringBuilder result = new StringBuilder();
        result.append("git_local\t" + repository.getLocalAddress() + "\n");
        int i = 0;
        for (String url : repository.getRemoteAddresses()) {
            result.append("git_remote_" + i++ + "\t" + url + "\n");
        }
        String commitId = repository.getCommitIdentifier();
        if (commitId == null) {
            commitId = "UNK (epoch=" + System.currentTimeMillis() + ")";
        }
        result.append("git_commit\t" + commitId + "\n");
        return result.toString();
    }

    public static ClassLoader getClassLoader(Object o) {
        Class<?> c = o.getClass();
        ClassLoader loader = c.getClassLoader();
        if (loader == null) {
            for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
            }
        }
        return loader;
    }

    public static File findSourceFile(Object o) {
        try {
            return new File(o.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

