/*
 * Decompiled with CFR 0.152.
 */
package briefj.run;

import briefj.BriefFiles;
import briefj.BriefIO;
import briefj.BriefLists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;

public class HashUtils {
    public static final HashFunction HASH_FUNCTION = Hashing.sha1();
    public static final String HASH_NAME = "sha1";
    public static Set<Pattern> standardExclusionPatterns = Sets.newHashSet((Object[])new Pattern[]{Pattern.compile("^[.].*$"), Pattern.compile("^std(err|out)[.]txt$"), Pattern.compile("^.*[.]sha1$")});

    public static HashCode computeFileHashCodesRecursively(File directory) {
        return HashUtils.computeFileHashCodesRecursively(directory, standardExclusionPatterns);
    }

    public static HashCode computeFileHashCodesRecursively(File directory, Set<Pattern> fileNameExclusionPatterns) {
        Hasher hasher = HASH_FUNCTION.newHasher();
        for (File file : BriefLists.sort(BriefFiles.ls(directory))) {
            if (HashUtils.match(file, fileNameExclusionPatterns)) continue;
            try {
                HashCode current = file.isDirectory() ? HashUtils.computeFileHashCodesRecursively(file, fileNameExclusionPatterns) : Files.hash((File)file, (HashFunction)HASH_FUNCTION);
                String currentString = current.toString();
                hasher.putUnencodedChars((CharSequence)currentString);
                File hashFile = new File(file.getParentFile(), "." + file.getName() + "." + HASH_NAME);
                BriefIO.write(hashFile, currentString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return hasher.hash();
    }

    private static boolean match(File file, Set<Pattern> fileNameExclusionPatterns) {
        for (Pattern p : fileNameExclusionPatterns) {
            if (!p.matcher(file.getName()).matches()) continue;
            return true;
        }
        return false;
    }
}

