/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.CognateData;
import cognates.CognateTreeGraph;
import cognates.CognateTreeNode;
import cognates.PhyloCognateInference;
import fig.basic.Indexer;
import fig.basic.LogInfo;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nuts.math.GMFctUtils;
import nuts.math.TabularGMFct;
import nuts.util.CollUtils;

public class CognateTree {
    private CognateTreeNode root;
    private Map<Taxon, CognateTreeNode> leaves;
    public static CognateTreeGraph graph;

    public CognateTree() {
    }

    public CognateTree(CognateTreeNode root, Map<Taxon, CognateTreeNode> leaves) {
        this.root = root;
        this.leaves = leaves;
        if (graph == null) {
            graph = CognateTreeGraph.constructFullGraph(root);
        }
    }

    public TabularGMFct<CognateTreeNode> getDefaultGMFct() {
        int B = PhyloCognateInference.phonemeIndexer.size();
        ArrayList<CognateTreeNode> preorder = CollUtils.list();
        CognateTreeNode.preorderTraversal(this.root, preorder);
        HashMap domain = CollUtils.map();
        for (CognateTreeNode node : preorder) {
            domain.put(node, B);
        }
        TabularGMFct<CognateTreeNode> fct = GMFctUtils.ones(graph, domain);
        double prior = 1.0 / (double)B;
        for (int s = 0; s < B; ++s) {
            fct.set(this.root, s, prior);
        }
        this.setEdgePotentials(this.root, fct);
        return fct;
    }

    private void setEdgePotentials(CognateTreeNode node, TabularGMFct<CognateTreeNode> fct) {
        CognateTreeNode rightChild;
        CognateTreeNode leftChild = node.getLeft();
        if (leftChild != null) {
            this.setEdgePotentialsHelper(node, leftChild, fct);
            this.setEdgePotentials(leftChild, fct);
        }
        if ((rightChild = node.getRight()) != null) {
            this.setEdgePotentialsHelper(node, rightChild, fct);
            this.setEdgePotentials(rightChild, fct);
        }
    }

    private void setEdgePotentialsHelper(CognateTreeNode parent, CognateTreeNode child, TabularGMFct<CognateTreeNode> fct) {
        for (int s1 = 0; s1 < fct.nStates(parent); ++s1) {
            for (int s2 = 0; s2 < fct.nStates(child); ++s2) {
                fct.set(parent, child, s1, s2, PhyloCognateInference.P[s1][s2]);
            }
        }
    }

    public int getNumLeaves() {
        return this.leaves.size();
    }

    public void addData(String gloss, List<CognateData> data) {
        for (CognateData datum : data) {
            LogInfo.logsForce(datum.getTaxon() + ":" + datum.getSequence());
            CognateTreeNode node = this.leaves.get(datum.getTaxon());
            node.addData(gloss, datum);
        }
    }

    public CognateTreeNode getNode(Taxon taxon) {
        return this.leaves.get(taxon);
    }

    public static CognateTree sampleDiscreteTree(Random rand, Indexer<Taxon> languageIndexer, double branchParam) {
        List<CognateTreeNode> nodes = CognateTree.createNodes(languageIndexer);
        HashMap<Taxon, CognateTreeNode> leaves = CollUtils.map();
        for (CognateTreeNode node : nodes) {
            leaves.put(node.getTaxon(), node);
        }
        int N2 = nodes.size();
        while (N2 > 1) {
            int left = rand.nextInt(N2);
            CognateTreeNode leftNode = nodes.remove(left);
            N2 = nodes.size();
            int right = rand.nextInt(N2);
            CognateTreeNode rightNode = nodes.remove(right);
            int branchLength = CognateTree.sampleGeometric(rand, branchParam);
            CognateTreeNode parent = new CognateTreeNode(leftNode, rightNode, branchLength);
            nodes.add(parent);
            leftNode.setParent(parent);
            rightNode.setParent(parent);
        }
        CognateTreeNode root = nodes.get(0);
        CognateTree tree = new CognateTree(root, leaves);
        return tree;
    }

    public static CognateTree nni(Random rand, CognateTree current) {
        CognateTree newTree = new CognateTree();
        ArrayList<CognateTreeNode> internalNodes = CollUtils.list();
        CognateTree.preorderInternalNodes(current.root.getLeft(), internalNodes);
        int leftSubTreeSize = internalNodes.size();
        CognateTree.preorderInternalNodes(current.root.getRight(), internalNodes);
        int sampledIndex = rand.nextInt(internalNodes.size());
        CognateTreeNode node1 = (CognateTreeNode)internalNodes.get(sampledIndex);
        CognateTreeNode[] nbrs1 = new CognateTreeNode[]{node1.getLeft(), node1.getRight()};
        CognateTreeNode node2 = node1.getParentNode();
        CognateTreeNode[] nbrs2 = new CognateTreeNode[2];
        if (node2 == current.root) {
            node2 = sampledIndex < leftSubTreeSize ? node2.getRight() : node2.getLeft();
            nbrs2[0] = node2.getLeft();
            nbrs2[1] = node2.getRight();
        } else {
            nbrs2[0] = node2.getParentNode();
            nbrs2[1] = node2.getLeft() == node1 ? node2.getRight() : node2.getLeft();
        }
        if (node1 == node2) {
            throw new RuntimeException();
        }
        int index1 = rand.nextInt(1);
        int index2 = rand.nextInt(1);
        CognateTreeNode nbr1 = nbrs1[index1];
        CognateTreeNode nbr2 = nbrs2[index2];
        return newTree;
    }

    private static void preorderInternalNodes(CognateTreeNode node, List<CognateTreeNode> nodes) {
        if (node.isLeaf()) {
            return;
        }
        nodes.add(node);
        CognateTree.preorderInternalNodes(node.getLeft(), nodes);
        CognateTree.preorderInternalNodes(node.getRight(), nodes);
    }

    private static List<CognateTreeNode> createNodes(Indexer<Taxon> languageIndexer) {
        ArrayList<CognateTreeNode> nodes = CollUtils.list();
        for (int l = 0; l < languageIndexer.size(); ++l) {
            CognateTreeNode node = new CognateTreeNode(languageIndexer.getObject(l));
            nodes.add(node);
        }
        return nodes;
    }

    public static int sampleGeometric(Random rand, double p) {
        double w = rand.nextDouble();
        int counter = 1;
        while (w < p) {
            w = rand.nextDouble();
            ++counter;
        }
        return counter;
    }

    private static String preorder(CognateTreeNode node, List<CognateTreeNode> nodes) {
        nodes.add(node);
        String str = node.getTaxon().toString();
        if (!node.isLeaf()) {
            str = str + "( ";
            str = str + CognateTree.preorder(node.getLeft(), nodes);
            str = str + ", ";
            str = str + CognateTree.preorder(node.getRight(), nodes);
            str = str + " )";
        }
        return str;
    }

    public String toString() {
        return this.root.getTaxon().toString();
    }
}

