/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.CognateTreeNode;
import cognates.PhyloCognateInference;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.Map;
import nuts.math.GMFct;
import nuts.math.Graph;
import nuts.util.CollUtils;

public class CognateTreeGMFct
implements GMFct<CognateTreeNode> {
    public static double[][] P;
    public static int NUM_PHONES;
    private String gloss;
    private Graph<CognateTreeNode> graph;
    private Map<Taxon, double[]> nodePotentials;
    private Map<UnorderedPair<Taxon, Taxon>, double[][]> edgePotentials;

    public CognateTreeGMFct(String gloss, Graph<CognateTreeNode> graph) {
        this.gloss = gloss;
        this.graph = graph;
        this.nodePotentials = CollUtils.map();
        this.edgePotentials = CollUtils.map();
    }

    @Override
    public double get(CognateTreeNode n1, CognateTreeNode n2, int s1, int s2) {
        UnorderedPair<Taxon, Taxon> pair = new UnorderedPair<Taxon, Taxon>(n1.getTaxon(), n2.getTaxon());
        if (!this.edgePotentials.containsKey(pair)) {
            throw new RuntimeException();
        }
        return this.edgePotentials.get(pair)[s1][s2];
    }

    @Override
    public Graph<CognateTreeNode> graph() {
        return this.graph;
    }

    @Override
    public int nStates(CognateTreeNode node) {
        return PhyloCognateInference.phonemeIndexer.size();
    }

    @Override
    public double get(CognateTreeNode n, int s) {
        if (!this.nodePotentials.containsKey(n.getTaxon())) {
            throw new RuntimeException();
        }
        return this.nodePotentials.get(n.getTaxon())[s];
    }

    public void set(CognateTreeNode n1, CognateTreeNode n2, int s1, int s2, double v) {
        UnorderedPair<Taxon, Taxon> pair = new UnorderedPair<Taxon, Taxon>(n1.getTaxon(), n2.getTaxon());
        double[][] edgePot = null;
        if (!this.edgePotentials.containsKey(pair)) {
            edgePot = new double[this.nStates(n1)][this.nStates(n2)];
            this.edgePotentials.put(pair, edgePot);
        } else {
            edgePot = this.edgePotentials.get(pair);
        }
        edgePot[s1][s2] = v;
    }

    public void set(CognateTreeNode n, int s, double v) {
        double[] pots = null;
        if (this.nodePotentials.containsKey(n.getTaxon())) {
            pots = this.nodePotentials.get(n.getTaxon());
        } else {
            pots = new double[this.nStates(n)];
            this.nodePotentials.put(n.getTaxon(), pots);
        }
        pots[s] = v;
    }
}

