/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.CognateTable;
import cognates.CognateTree;
import cognates.CognateTreeNode;
import cognates.PhyloCognateInference;
import fig.basic.Pair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.util.CollUtils;

public class DirichletProcessState {
    private CognateTree tree;
    private List<CognateTable> tables;
    private List<Integer> customerList;

    public DirichletProcessState(CognateTree tree) {
        this.tree = tree;
        this.tables = CollUtils.list();
        this.customerList = CollUtils.list();
        this.initCustomerList();
    }

    public void initCustomerList() {
        for (int i = 0; i < PhyloCognateInference.languageIndexer.size(); ++i) {
            this.customerList.add(i);
        }
    }

    public DirichletProcessState(DirichletProcessState oldState) {
        this.tree = oldState.tree;
        this.tables = CollUtils.list();
        for (CognateTable table : oldState.tables) {
            this.tables.add(table);
        }
        this.customerList = CollUtils.list();
        for (int i = 0; i < oldState.customerList.size(); ++i) {
            this.customerList.add(oldState.customerList.get(i));
        }
    }

    public int numIterationsLeft() {
        return this.customerList.size();
    }

    public List<Pair<DirichletProcessState, Double>> generateParticles(Random rand, String gloss) {
        ArrayList<Pair<DirichletProcessState, Double>> particles = CollUtils.list();
        if (this.numIterationsLeft() == 0) {
            throw new RuntimeException("No iterations left as all customers are seated.");
        }
        int sampled = rand.nextInt(this.customerList.size());
        int index = this.customerList.remove(sampled);
        Taxon customerTaxon = PhyloCognateInference.languageIndexer.getObject(index);
        CognateTreeNode customer = this.tree.getNode(customerTaxon);
        for (int tableIndex = 0; tableIndex < this.tables.size(); ++tableIndex) {
            particles.add(DirichletProcessState.addCustomer(tableIndex, customer, this));
        }
        particles.add(DirichletProcessState.createTable(customer, gloss, this));
        return particles;
    }

    public double computeWeight() {
        double weight = 0.0;
        for (int i = 0; i < this.tables.size(); ++i) {
            weight += this.tables.get(i).getLogLik();
        }
        return weight;
    }

    public static Pair<DirichletProcessState, Double> createTable(CognateTreeNode customer, String gloss, DirichletProcessState curr) {
        DirichletProcessState newState = new DirichletProcessState(curr);
        CognateTable newTable = new CognateTable(customer, gloss, curr.tree);
        double logLik = newTable.getLogLik();
        newState.tables.add(newTable);
        return new Pair<DirichletProcessState, Double>(newState, logLik);
    }

    public static Pair<DirichletProcessState, Double> addCustomer(int tableIndex, CognateTreeNode customer, DirichletProcessState curr) {
        DirichletProcessState newState = new DirichletProcessState(curr);
        CognateTable oldTable = newState.tables.get(tableIndex);
        double oldLogLik = oldTable.getLogLik();
        CognateTable newTable = oldTable.seat(customer);
        double newLogLik = newTable.getLogLik();
        newState.tables.set(tableIndex, newTable);
        double newWeight = newLogLik - oldLogLik;
        return new Pair<DirichletProcessState, Double>(newState, newWeight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tables.size() + " cognate set(s)\n");
        for (CognateTable table : this.tables) {
            sb.append(table.toString() + "\n");
        }
        return sb.toString();
    }
}

