/*
 * Decompiled with CFR 0.152.
 */
package cognates;

import cognates.CognateData;
import cognates.CognateTree;
import cognates.DirichletProcessSMC;
import fig.basic.IOUtils;
import fig.basic.Indexer;
import fig.basic.LogInfo;
import fig.basic.Option;
import goblin.Taxon;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nuts.io.IO;
import nuts.util.CollUtils;

public class PhyloCognateInference
implements Runnable {
    Random rand = new Random(1L);
    @Option(required=true)
    public double branchParam;
    @Option(required=true)
    public String datafile;
    @Option(required=true)
    public int N;
    public static Indexer<Taxon> languageIndexer;
    public static Indexer<Character> phonemeIndexer;
    public static double[][] P;

    private Map<String, List<CognateData>> readAlignmentData() throws IOException {
        HashMap<String, List<CognateData>> data = CollUtils.map();
        BufferedReader reader = IOUtils.openIn(this.datafile);
        String line = reader.readLine();
        String[] languages = line.trim().split("\\s+");
        languageIndexer = new Indexer();
        phonemeIndexer = new Indexer();
        for (int l = 1; l < languages.length; ++l) {
            languageIndexer.add(new Taxon(languages[l]));
        }
        int numLines = 0;
        LogInfo.track("Process glosses...");
        while ((line = reader.readLine()) != null) {
            LogInfo.logs("Processing gloss " + ++numLines);
            String[] w = line.split("\\s+");
            String gloss = w[0].trim();
            ArrayList glossSet = CollUtils.list();
            for (int l = 1; l < languages.length; ++l) {
                String word = w[l].trim();
                CognateData cognateData = new CognateData(word, languageIndexer.getObject(l - 1));
                for (int i = 0; i < word.length(); ++i) {
                    Character ch = Character.valueOf(word.charAt(i));
                    if (phonemeIndexer.contains(ch)) continue;
                    phonemeIndexer.add(ch);
                }
                glossSet.add(cognateData);
            }
            data.put(gloss, glossSet);
        }
        LogInfo.end_track();
        return data;
    }

    @Override
    public void run() {
        Map<String, List<CognateData>> data = null;
        try {
            data = this.readAlignmentData();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (data == null) {
            throw new RuntimeException();
        }
        DirichletProcessSMC dpSMC = new DirichletProcessSMC(this.N);
        PhyloCognateInference.initTransitionProb(phonemeIndexer.size());
        CognateTree tree = CognateTree.sampleDiscreteTree(this.rand, languageIndexer, this.branchParam);
        LogInfo.track("Adding data");
        for (String gloss : data.keySet()) {
            LogInfo.track("Initialize Tree for gloss = " + gloss);
            tree.addData(gloss, data.get(gloss));
            dpSMC.initialize(this.rand, gloss, tree);
            LogInfo.end_track();
        }
        LogInfo.end_track();
        LogInfo.logs("-----------current tree-----------");
        LogInfo.logs(tree.toString());
    }

    private static void initTransitionProb(int nStates) {
        if (P == null) {
            P = new double[nStates][nStates];
        }
        double param = 1.0 / (double)nStates;
        for (int s1 = 0; s1 < nStates; ++s1) {
            for (int s2 = 0; s2 < nStates; ++s2) {
                PhyloCognateInference.P[s1][s2] = param;
            }
        }
    }

    public static void main(String[] args) {
        IO.run(args, new PhyloCognateInference());
    }
}

