/*
 * Decompiled with CFR 0.152.
 */
package conifer.clock;

import conifer.clock.ClockTreeUtils;
import goblin.Taxon;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.RootedTree;

public class ClockTree {
    private final Map<Set<Taxon>, Double> heights;

    public ClockTree(Map<Set<Taxon>, Double> heights) {
        this.heights = heights;
    }

    public Set<Taxon> leaves() {
        HashSet<Taxon> leaves = new HashSet<Taxon>();
        for (Set<Taxon> node : this.getHeights().keySet()) {
            leaves.addAll(node);
        }
        return leaves;
    }

    public Double height(Set<Taxon> clades) {
        return this.getHeights().get(clades);
    }

    public Set<Set<Taxon>> nodes() {
        return this.getHeights().keySet();
    }

    public Counter<Set<Taxon>> internalHeights() {
        Counter<Set<Taxon>> result = new Counter<Set<Taxon>>();
        for (Set<Taxon> node : this.getHeights().keySet()) {
            if (this.height(node) == 0.0) continue;
            result.setCount(node, this.height(node));
        }
        return result;
    }

    public static <T> T sample(Counter<T> items, Random rand) {
        int index = rand.nextInt(items.size());
        int i = 0;
        T selected = null;
        for (T tax : items) {
            if (i++ != index) continue;
            selected = tax;
            break;
        }
        return selected;
    }

    public Set<Taxon> shortChild(Set<Taxon> selected) {
        HashSet<Taxon> copy = CollUtils.set(selected);
        copy.removeAll(this.tallChild(selected));
        return copy;
    }

    public Set<Taxon> tallChild(Set<Taxon> selected) {
        Set<Taxon> argmax = null;
        double max = Double.NEGATIVE_INFINITY;
        for (Set<Taxon> node : this.nodes()) {
            if (!(this.height(node) > max) || selected.equals(node) || !selected.containsAll(node)) continue;
            max = this.height(node);
            argmax = node;
        }
        return argmax;
    }

    public Set<Taxon> parent(Set<Taxon> selected) {
        Set<Taxon> argmin = null;
        double min = Double.POSITIVE_INFINITY;
        for (Set<Taxon> node : this.nodes()) {
            if (!(this.height(node) < min) || selected.equals(node) || !node.containsAll(selected)) continue;
            min = this.height(node);
            argmin = node;
        }
        return argmin;
    }

    public String toString() {
        return RootedTree.Util.toString(ClockTreeUtils.toRooted(this));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getHeights() == null ? 0 : this.getHeights().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClockTree other = (ClockTree)obj;
        return !(this.getHeights() == null ? other.getHeights() != null : !this.getHeights().equals(other.getHeights()));
    }

    public Map<Set<Taxon>, Double> getHeights() {
        return this.heights;
    }
}

