/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.data;

import conifer.data.AlignedData;
import conifer.data.DataModel;
import conifer.data.DataOptions;
import conifer.data.PhylogeneticData;
import conifer.fastmetrics.CladeMetrics;
import conifer.multicategories.PhylogeneticFactorGraph;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import ma.RateMatrixLoader;
import nuts.io.IO;
import pty.RootedTree;
import pty.UnrootedTree;

public class WritePhylip
implements Runnable {
    private static DataOptions syntheticOptions = new DataOptions();

    public static void main(String[] args) {
        IO.run(args, new WritePhylip(), "synth", syntheticOptions);
    }

    @Override
    public void run() {
        PhylogeneticData data2 = DataModel.GENERATED.loadDataset(syntheticOptions);
        AlignedData d = (AlignedData)data2.getObservedTaxonIndexData();
        Map<Taxon, String> m = d.getAlignment().gapPaddedSequences();
        File raxDir = new File(Execution.getFile("raxdir"));
        raxDir.mkdir();
        File dataFile = new File(raxDir, "input.phylip");
        PrintWriter out = IOUtils.openOutHard(dataFile);
        out.println(" " + d.observations().size() + " " + d.nSites());
        int longest = -1;
        for (Taxon t : d.observations().keySet()) {
            int curLen = t.toString().length();
            if (curLen <= longest) continue;
            longest = curLen;
        }
        for (Taxon t : d.observations().keySet()) {
            String s = t.toString();
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < longest + 2; ++i) {
                line.append(i < s.length() ? Character.valueOf(s.charAt(i)) : " ");
            }
            line.append(m.get(t));
            out.println(line);
        }
        out.close();
        IO.call("raxmlHPC-SSE3 -m GTRGAMMA -n outfile -s " + dataFile.getName() + " -p 2342 ", null, raxDir);
        File output = new File(raxDir, "RAxML_bestTree.outfile");
        String treeFileContents = IO.f2s(output).replaceAll("[:]0[.]0[;]", ";");
        UnrootedTree ut = UnrootedTree.fromNewick(treeFileContents);
        RootedTree rt = RootedTree.Util.fromNewickString(treeFileContents);
        Map<CladeMetrics.TreeMetric, Double> map = CladeMetrics.computeTreeMetrics(data2.getPhylogeny(), ut);
        for (CladeMetrics.TreeMetric o : map.keySet()) {
            System.out.println("" + (Object)((Object)o) + "\t" + map.get((Object)o));
        }
        double[][] rateMtx = RateMatrixLoader.k2p();
        PhylogeneticFactorGraph fg = PhylogeneticFactorGraph.createSingleCategoryFromStationaryProcess(rt, rateMtx, d);
        LogInfo.logsForce("log ll: " + fg.getSumProductPosteriorCalculator().logZ());
    }
}

