/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.extractors;

import conifer.ml.AnnotatedCharacter;
import conifer.ml.extractors.BivariateFeatureExtractor;
import nuts.util.Counter;

public class RateFeatureExtractor
implements BivariateFeatureExtractor<AnnotatedCharacter> {
    private final boolean isFirstCategoryInvariant;

    public RateFeatureExtractor(boolean isFirstCategoryInvariant) {
        this.isFirstCategoryInvariant = isFirstCategoryInvariant;
    }

    @Override
    public void extract(Counter counts, AnnotatedCharacter state1, AnnotatedCharacter state2) {
        int i;
        int category = state1.category;
        if (this.isFirstCategoryInvariant && category == 0) {
            return;
        }
        counts.incrementCount(this.prefix() + "globalRate", 1.0);
        int n = i = this.isFirstCategoryInvariant ? 2 : 1;
        while (i <= category) {
            counts.incrementCount(this.prefix() + "rate-" + i, 1.0);
            ++i;
        }
    }

    private String prefix() {
        return this.toString() + ":";
    }

    public String toString() {
        return "rateExtractor";
    }
}

