/*
 * Decompiled with CFR 0.152.
 */
package conifer.msa;

import conifer.apps.Main;
import conifer.evol.EvolutionaryModel;
import conifer.evol.EvolutionaryOptions;
import conifer.exp.ExperimentalSetup;
import conifer.msa.LinearizationProposal;
import conifer.msa.LocalMSAProposal;
import conifer.msa.TreeMSAState;
import conifer.pip.LinearizedAlignment;
import conifer.pip.PIPForwardSampler;
import conifer.pip.PIPLikelihoodCalculator;
import conifer.proposals.ProposalModel;
import ev.poi.PoissonParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import ma.GreedyDecoder;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import monaco.mcmc.MCAlgorithmType;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.MathUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import pty.RandomRootedTrees;
import pty.RootedTree;

public class MSAProposalTests {
    PoissonParameters pip;
    RootedTree rt;
    PIPLikelihoodCalculator calc2;
    MSAPoset msa;
    MSAPoset maxRecall;
    Counter<GreedyDecoder.Edge> edges;
    LinearizedAlignment lia;
    Random rand = new Random(1L);
    LocalMSAProposal prop;
    TreeMSAState state;

    public static void main(String[] args) {
        new MSAProposalTests().testF1();
    }

    @Test
    public void testF1() {
        Main main = new Main();
        main.allOptions.dataOptions.generatingEvolutionaryOptions.model = EvolutionaryModel.PIP;
        main.allOptions.dataOptions.generatingEvolutionaryOptions.pipParamType = EvolutionaryOptions.PIPParamType.LEN_INT;
        main.allOptions.dataOptions.generatingEvolutionaryOptions.pipParam1 = 10.0;
        main.allOptions.dataOptions.generatingEvolutionaryOptions.pipParam2 = 1.0;
        main.allOptions.inferenceEvolutionaryOptions.model = EvolutionaryModel.PIP;
        main.allOptions.inferenceEvolutionaryOptions.pipParamType = EvolutionaryOptions.PIPParamType.LEN_INT;
        main.allOptions.inferenceEvolutionaryOptions.pipParam1 = 10.0;
        main.allOptions.inferenceEvolutionaryOptions.pipParam2 = 1.0;
        main.allOptions.dataOptions.generatingTreeOptions.nTaxa = 5;
        main.allOptions.experimentOptions.experiments = new ArrayList<ExperimentalSetup>(Arrays.asList(ExperimentalSetup.MSA_HELDOUT));
        main.allOptions.mcOptions.algorithm = MCAlgorithmType.TEMPERED_MCMC;
        main.allOptions.proposalOptions.proposalModels = new ArrayList<ProposalModel>(Arrays.asList(ProposalModel.LOCAL_MSA));
        main.allOptions.proposalOptions.weights = new ArrayList<Double>(Arrays.asList(1.0));
        IO.run(new String[0], main);
    }

    @Test
    public void testUndo() {
        boolean init = false;
        for (int i = 0; i < 1000; ++i) {
            HashSet<GreedyDecoder.Edge> newEdges;
            HashSet<GreedyDecoder.Edge> initEdges = CollUtils.set(this.msa.edges());
            double logRatio = this.prop.propose_logRatio(this.rand, this.state, true).getSecond();
            System.out.println(Math.exp(logRatio));
            boolean accept = this.rand.nextBoolean();
            this.state.wasProposalAccepted(accept);
            System.out.println(accept);
            if (!accept && !(newEdges = CollUtils.set(this.msa.edges())).equals(initEdges)) {
                throw new RuntimeException();
            }
            if (accept) {
                init = true;
            }
            if (!init) continue;
            double logBwdLinPr = LinearizationProposal.logPrLinearization(this.msa.getPoset(), this.state.linearization);
            Assert.assertEquals((double)logBwdLinPr, (double)this.state.lastAcceptedLinearizationLogPr, (double)MathUtils.threshold);
        }
    }

    @Before
    public void setup() {
        this.pip = PoissonParameters.createFromAdditiveLengthIntensityParameterization(RateMatrixLoader.rnaIndexer(), RateMatrixLoader.k2p(), 100.0, 0.2);
        this.rt = RandomRootedTrees.sampleCoalescent(this.rand, 10, 1.0);
        PIPForwardSampler pipf = new PIPForwardSampler(this.pip, this.rt);
        this.msa = pipf.sampleMSA(this.rand);
        System.out.println("Generating msa:\n" + this.msa);
        this.calc2 = new PIPLikelihoodCalculator(this.pip, new LinearizedAlignment(this.msa), this.rt);
        System.out.println("logLL = " + this.calc2.computeDataLogProbabilityGivenTree());
        this.lia = new LinearizedAlignment(new MSAPoset(this.msa.sequences()));
        this.prop = new LocalMSAProposal();
        this.state = new TreeMSAState(this.msa, this.rt, this.pip);
    }
}

