/*
 * Decompiled with CFR 0.152.
 */
package conifer.ssm;

import conifer.ssm.EditType;
import java.util.ArrayList;
import java.util.List;

public class Edit {
    public static char[] alphabet = new char[]{'A', 'C', 'G', 'T'};
    public final String oldSeq;
    public final String newSeq;

    public static boolean isRepeat(String s, int position, int indelLen) {
        if (position < indelLen || position + indelLen > s.length()) {
            return false;
        }
        for (int i = 0; i < indelLen; ++i) {
            if (s.charAt(position + i) == s.charAt(position - indelLen + i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.newSeq == null ? 0 : this.newSeq.hashCode());
        result = 31 * result + (this.oldSeq == null ? 0 : this.oldSeq.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edit other = (Edit)obj;
        if (this.newSeq == null ? other.newSeq != null : !this.newSeq.equals(other.newSeq)) {
            return false;
        }
        return !(this.oldSeq == null ? other.oldSeq != null : !this.oldSeq.equals(other.oldSeq));
    }

    public boolean isRepeat() {
        return Math.abs(this.deltaLength()) > 1;
    }

    public EditType getType() {
        if (this.deltaLength() == 0) {
            return EditType.SUB;
        }
        if (this.deltaLength() > 0) {
            return EditType.INS;
        }
        return EditType.DEL;
    }

    public String getSummaryString() {
        return (Object)((Object)this.getType()) + "(" + this.isRepeat() + ")";
    }

    public int deltaLength() {
        return this.newSeq.length() - this.oldSeq.length();
    }

    public String toString() {
        return "Edit(type=" + (Object)((Object)this.getType()) + ", isRepeat=" + this.isRepeat() + ", oldSeq=" + this.oldSeq + ", newSeq=" + this.newSeq + ")";
    }

    public Edit(String oldSeq, String newSeq) {
        this.oldSeq = oldSeq;
        this.newSeq = newSeq;
    }

    public static Edit ssmInsert(String s, int pos, int len) {
        return Edit._insertion(s, pos, s.substring(pos - len, pos), true);
    }

    public static Edit ssmDelete(String s, int pos, int len) {
        if (!s.subSequence(pos - len, pos).equals(s.subSequence(pos, pos + len))) {
            throw new RuntimeException();
        }
        return Edit._deletion(s, pos, len, true);
    }

    private static Edit _deletion(String s, int pos, int len, boolean isSSM) {
        StringBuilder newString = new StringBuilder();
        newString.append(s.subSequence(0, pos));
        newString.append(s.subSequence(pos + len, s.length()));
        return new Edit(s, newString.toString());
    }

    public static Edit substitution(String s, int pos, char newValue) {
        StringBuilder newString = new StringBuilder();
        newString.append(s.subSequence(0, pos));
        newString.append(newValue);
        newString.append(s.subSequence(pos + 1, s.length()));
        return new Edit(s, newString.toString());
    }

    public static Edit insertion(String s, int pos, char newValue) {
        return Edit._insertion(s, pos, "" + newValue, false);
    }

    private static Edit _insertion(String s, int pos, String addendum, boolean isSSM) {
        StringBuilder newString = new StringBuilder();
        newString.append(s.subSequence(0, pos));
        newString.append(addendum);
        newString.append(s.subSequence(pos, s.length()));
        return new Edit(s, newString.toString());
    }

    public static Edit deletion(String s, int pos) {
        return Edit._deletion(s, pos, 1, false);
    }

    public static List<Edit> pointSubstitutions(String current) {
        ArrayList<Edit> candidates = new ArrayList<Edit>();
        for (int i = 0; i < current.length(); ++i) {
            char cur = current.charAt(i);
            for (int j = 0; j < alphabet.length; ++j) {
                if (alphabet[j] == cur) continue;
                candidates.add(Edit.substitution(current, i, alphabet[j]));
            }
        }
        return candidates;
    }

    public static List<Edit> pointDeletions(String current) {
        ArrayList<Edit> candidates = new ArrayList<Edit>();
        for (int i = 0; i < current.length(); ++i) {
            candidates.add(Edit.deletion(current, i));
        }
        return candidates;
    }

    public static List<Edit> pointInsertions(String current) {
        ArrayList<Edit> candidates = new ArrayList<Edit>();
        for (int i = 0; i < current.length() + 1; ++i) {
            for (int j = 0; j < alphabet.length; ++j) {
                candidates.add(Edit.insertion(current, i, alphabet[j]));
            }
        }
        return candidates;
    }

    public static List<Edit> ssmInsertions(String current, int ssmLength) {
        ArrayList<Edit> result = new ArrayList<Edit>();
        for (int i = ssmLength; i < current.length() + 1; ++i) {
            result.add(Edit.ssmInsert(current, i, ssmLength));
        }
        return result;
    }

    public static List<Edit> ssmDeletions(String current, int ssmLength) {
        ArrayList<Edit> result = new ArrayList<Edit>();
        for (int i = ssmLength; i < current.length(); ++i) {
            if (!Edit.isRepeat(current, i, ssmLength)) continue;
            result.add(Edit.ssmDelete(current, i, ssmLength));
        }
        return result;
    }
}

