/*
 * Decompiled with CFR 0.152.
 */
package conifer.trees;

import conifer.Phylogeny;
import conifer.particle.PhyloParticle;
import conifer.trees.StandardNonClockPriorDensity;
import conifer.trees.TreeOptions;
import ev.ex.TreeGenerators;
import monaco.Density;
import pty.RandomRootedTrees;

public enum TreeModel {
    COALESCENT{

        @Override
        public Phylogeny sample(TreeOptions options) {
            return RandomRootedTrees.sampleCoalescent(options.rand, options.nTaxa, options.rate);
        }

        @Override
        public Density<PhyloParticle> getPriorDensity(TreeOptions options) {
            throw new RuntimeException();
        }

        @Override
        public boolean isClock() {
            return true;
        }
    }
    ,
    STANDARD_NON_CLOCK{

        @Override
        public Phylogeny sample(TreeOptions options) {
            return TreeGenerators.sampleUniformTopologyNonClock(options.rand, options.getBranchDistribution(), options.nTaxa);
        }

        @Override
        public Density<PhyloParticle> getPriorDensity(TreeOptions options) {
            return new StandardNonClockPriorDensity(options.getBranchDistribution());
        }

        @Override
        public boolean isClock() {
            return false;
        }
    };


    public abstract Phylogeny sample(TreeOptions var1);

    public abstract Density<PhyloParticle> getPriorDensity(TreeOptions var1);

    public abstract boolean isClock();
}

