/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MultivariateFunction;

public class BoundsCheckedFunction
implements MultivariateFunction {
    private MultivariateFunction f;
    private double veryLarge;

    public BoundsCheckedFunction(MultivariateFunction func) {
        this(func, 1000000.0);
    }

    public BoundsCheckedFunction(MultivariateFunction func, double largeNumber) {
        this.f = func;
        this.veryLarge = largeNumber;
    }

    @Override
    public double evaluate(double[] x) {
        int len = this.f.getNumArguments();
        for (int i = 0; i < len; ++i) {
            if (!(x[i] < this.f.getLowerBound(i)) && !(x[i] > this.f.getUpperBound(i))) continue;
            return this.veryLarge;
        }
        return this.f.evaluate(x);
    }

    @Override
    public int getNumArguments() {
        return this.f.getNumArguments();
    }

    @Override
    public double getLowerBound(int n) {
        return this.f.getLowerBound(n);
    }

    @Override
    public double getUpperBound(int n) {
        return this.f.getUpperBound(n);
    }
}

