/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.matrixAlgebra.Vector;

public class ComplexArray {
    public final double[] real;
    public final double[] complex;
    public final int length;

    public ComplexArray(double[] real) {
        this(real, new double[real.length]);
    }

    public ComplexArray(double[] real, double[] complex) {
        this.real = real;
        this.complex = complex;
        this.length = real.length;
    }

    public void conjugate() {
        for (int i = 0; i < this.length; ++i) {
            this.complex[i] = -this.complex[i];
        }
    }

    public ComplexArray product(ComplexArray x) {
        double[] newReal = new double[this.length];
        double[] newComplex = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            double a = this.real[i];
            double b = this.complex[i];
            double c = x.real[i];
            double d = x.complex[i];
            newReal[i] = a * c - b * d;
            newComplex[i] = a * d + b * c;
        }
        return new ComplexArray(newReal, newComplex);
    }

    public String toString() {
        return "\nReal   : " + new Vector(this.real).toString() + "\nComplex: " + new Vector(this.complex).toString();
    }

    public static double[] interleave(double[] real, double[] complex) {
        int length = real.length;
        double[] out = new double[length * 2];
        for (int i = 0; i < length; ++i) {
            out[2 * i] = real[i];
            out[2 * i + 1] = complex[i];
        }
        return out;
    }
}

