/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.distributions.GammaDistribution;
import dr.stats.DiscreteStatistics;

public class EmpiricalBayesPoissonSmoother {
    public static double[] smooth(double[] in) {
        int length = in.length;
        double[] out = new double[length];
        double[] gammaStats = EmpiricalBayesPoissonSmoother.getNegBin(in);
        double alpha = gammaStats[0];
        double beta = gammaStats[1];
        double mean = gammaStats[2];
        if (beta == 0.0) {
            for (int i = 0; i < length; ++i) {
                out[i] = mean;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                out[i] = (in[i] + alpha) / (1.0 + 1.0 / beta);
            }
        }
        return out;
    }

    public static double[] smoothWithSample(double[] in) {
        int length = in.length;
        double[] out = new double[length];
        double[] gammaStats = EmpiricalBayesPoissonSmoother.getNegBin(in);
        double alpha = gammaStats[0];
        double beta = gammaStats[1];
        double mean = gammaStats[2];
        if (beta == 0.0) {
            for (int i = 0; i < length; ++i) {
                out[i] = mean;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                double shape = in[i] + alpha;
                double scale = 1.0 / (1.0 + 1.0 / beta);
                out[i] = GammaDistribution.nextGamma(shape, scale);
            }
        }
        return out;
    }

    public static double[] smoothOld(double[] in) {
        int length = in.length;
        double[] out = new double[length];
        double[] gammaStats = EmpiricalBayesPoissonSmoother.getNegBin(in);
        for (int i = 0; i < length; ++i) {
            out[i] = (in[i] + gammaStats[0]) / (1.0 + 1.0 / gammaStats[1]);
        }
        return out;
    }

    private static double[] getNegBin(double[] array) {
        double returnArray1;
        double mean = DiscreteStatistics.mean(array);
        double variance = DiscreteStatistics.variance(array, mean);
        double returnArray0 = 1.0 - mean / variance;
        double shape = returnArray1 = mean * ((1.0 - returnArray0) / returnArray0);
        double scale = returnArray0 / (1.0 - returnArray0);
        if (variance <= mean) {
            shape = 0.0;
            scale = 0.0;
        }
        return new double[]{shape, scale, mean};
    }
}

