/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import java.util.Arrays;

public class KroneckerOperation {
    public static double[] sum(double[] A, double[] B) {
        int dim = A.length * B.length;
        double[] out = new double[dim];
        double[] tmpA = new double[dim];
        double[] tmpB = new double[dim];
        double[] Im = KroneckerOperation.makeIdentityVector(A.length);
        double[] In = KroneckerOperation.makeIdentityVector(B.length);
        KroneckerOperation.sum(A, B, Im, In, tmpA, tmpB, out);
        return out;
    }

    public static void sum(double[] A, double[] B, double[] Im, double[] In, double[] tmpA, double[] tmpB, double[] C) {
        int m = A.length;
        int n = B.length;
        int dim = m * n;
        if (C.length != dim || Im.length != m || In.length != n || tmpA.length != dim || tmpB.length != dim) {
            throw new RuntimeException("Wrong dimensions in Kronecker sum");
        }
        KroneckerOperation.product(A, m, 1, In, n, 1, tmpA);
        KroneckerOperation.product(Im, m, 1, B, n, 1, tmpB);
        for (int i = 0; i < dim; ++i) {
            C[i] = tmpA[i] + tmpB[i];
        }
    }

    public static double[] sum(double[] A, int m, double[] B, int n) {
        int dim = m * n;
        double[] out = new double[dim * dim];
        double[] tmpA = new double[dim * dim];
        double[] tmpB = new double[dim * dim];
        double[] Im = KroneckerOperation.makeIdentityMatrix(m);
        double[] In = KroneckerOperation.makeIdentityMatrix(n);
        KroneckerOperation.sum(A, m, B, n, Im, In, tmpA, tmpB, out);
        return out;
    }

    public static void sum(double[] A, int m, double[] B, int n, double[] Im, double[] In, double[] tmpA, double[] tmpB, double[] C) {
        int dim = m * n;
        if (C.length != dim * dim || A.length != m * m || B.length != n * n || Im.length != m * m || In.length != n * n || tmpA.length != dim * dim || tmpB.length != dim * dim) {
            throw new RuntimeException("Wrong dimensions in Kronecker sum");
        }
        KroneckerOperation.product(A, m, m, In, n, n, tmpA);
        KroneckerOperation.product(Im, m, m, B, n, n, tmpB);
        for (int i = 0; i < dim * dim; ++i) {
            C[i] = tmpA[i] + tmpB[i];
        }
    }

    private static double[] makeIdentityMatrix(int dim) {
        double[] out = new double[dim * dim];
        for (int i = 0; i < dim; ++i) {
            out[i * dim + i] = 1.0;
        }
        return out;
    }

    private static double[] makeIdentityVector(int dim) {
        double[] out = new double[dim];
        Arrays.fill(out, 1.0);
        return out;
    }

    public static double[] product(double[] A, int m, int n, double[] B, int p, int q) {
        double[] out = new double[m * p * n * q];
        KroneckerOperation.product(A, m, n, B, p, q, out);
        return out;
    }

    public static void product(double[] A, int m, int n, double[] B, int p, int q, double[] out) {
        int dimi = m * p;
        int dimj = n * q;
        if (out.length != dimi * dimj || A.length != m * n || B.length != p * q) {
            throw new RuntimeException("Wrong dimensions in Kronecker product");
        }
        for (int i = 0; i < m; ++i) {
            int iOffset = i * p;
            for (int j = 0; j < n; ++j) {
                int jOffset = j * q;
                double aij = A[i * n + j];
                for (int k = 0; k < p; ++k) {
                    for (int l = 0; l < q; ++l) {
                        out[(iOffset + k) * dimj + jOffset + l] = aij * B[k * q + l];
                    }
                }
            }
        }
    }

    public static double[][] product(double[][] A, double[][] B) {
        int m = A.length;
        int n = A[0].length;
        int p = B.length;
        int q = B[0].length;
        double[][] out = new double[m * p][n * q];
        KroneckerOperation.product(A, B, out);
        return out;
    }

    public static void product(double[][] A, double[][] B, double[][] out) {
        int m = A.length;
        int n = A[0].length;
        int p = B.length;
        int q = B[0].length;
        if (out == null || out.length != m * p || out[0].length != n * q) {
            throw new RuntimeException("Wrong dimensions in Kronecker product");
        }
        for (int i = 0; i < m; ++i) {
            int iOffset = i * p;
            for (int j = 0; j < n; ++j) {
                int jOffset = j * q;
                double aij = A[i][j];
                for (int k = 0; k < p; ++k) {
                    for (int l = 0; l < q; ++l) {
                        out[iOffset + k][jOffset + l] = aij * B[k][l];
                    }
                }
            }
        }
    }
}

