/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

public class LogTricks {
    public static final double maxFloat = Double.MAX_VALUE;
    public static final double logLimit = -1.7976931348623156E306;
    public static final double logZero = -1.7976931348623157E308;
    public static final double NATS = 400.0;

    public static double logSumNoCheck(double x, double y) {
        double temp = y - x;
        if (Math.abs(temp) > 400.0) {
            return x > y ? x : y;
        }
        return x + StrictMath.log1p(StrictMath.exp(temp));
    }

    public static double logSum(double[] x) {
        double sum = x[0];
        int len = x.length;
        for (int i = 1; i < len; ++i) {
            sum = LogTricks.logSumNoCheck(sum, x[i]);
        }
        return sum;
    }

    public static double logSum(double x, double y) {
        double temp = y - x;
        if (temp > 400.0 || x < -1.7976931348623156E306) {
            return y;
        }
        if (temp < -400.0 || y < -1.7976931348623156E306) {
            return x;
        }
        if (temp < 0.0) {
            return x + StrictMath.log1p(StrictMath.exp(temp));
        }
        return y + StrictMath.log1p(StrictMath.exp(-temp));
    }

    public static void logInc(Double x, double y) {
        double temp = y - x;
        if (temp > 400.0 || x < -1.7976931348623156E306) {
            x = y;
        } else if (!(temp < -400.0) && !(y < -1.7976931348623156E306)) {
            x = x + StrictMath.log1p(StrictMath.exp(temp));
        }
    }

    public static double logDiff(double x, double y) {
        assert (x > y);
        double temp = y - x;
        if (temp < -400.0 || y < -1.7976931348623156E306) {
            return x;
        }
        return x + StrictMath.log1p(-Math.exp(temp));
    }
}

