/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.GammaFunction;
import dr.math.MersenneTwisterFast;
import dr.util.NumberFormatter;
import java.text.NumberFormat;
import java.text.ParseException;

public class MathUtils {
    private static final MersenneTwisterFast random = MersenneTwisterFast.DEFAULT_INSTANCE;

    private MathUtils() {
    }

    public static int randomChoice(double[] cf) {
        int s;
        double U = random.nextDouble();
        if (U <= cf[0]) {
            s = 0;
        } else {
            for (s = 1; !(s >= cf.length || U <= cf[s] && U > cf[s - 1]); ++s) {
            }
        }
        return s;
    }

    public static int randomChoicePDF(double[] pdf) {
        int i;
        double U = random.nextDouble() * MathUtils.getTotal(pdf);
        for (i = 0; i < pdf.length; ++i) {
            if (!((U -= pdf[i]) < 0.0)) continue;
            return i;
        }
        for (i = 0; i < pdf.length; ++i) {
            System.out.println(i + "\t" + pdf[i]);
        }
        throw new Error("randomChoiceUnnormalized falls through -- negative components in input distribution?");
    }

    public static double[] getNormalized(double[] array) {
        double[] newArray = new double[array.length];
        double total = MathUtils.getTotal(array);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i] / total;
        }
        return newArray;
    }

    public static double getTotal(double[] array, int start, int end) {
        double total = 0.0;
        for (int i = start; i < end; ++i) {
            total += array[i];
        }
        return total;
    }

    public static double getTotal(double[] array) {
        return MathUtils.getTotal(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSeed() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.getSeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSeed(long seed) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.setSeed(seed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte nextByte() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nextBoolean() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextBytes(byte[] bs) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.nextBytes(bs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char nextChar() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextGaussian() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextGaussian();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextGamma(double alpha, double lambda) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextGamma(alpha, lambda);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextDouble() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextDouble();
        }
    }

    public static double randomLogDouble() {
        return Math.log(MathUtils.nextDouble());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextExponential(double lambda) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return -1.0 * Math.log(1.0 - random.nextDouble()) / lambda;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextInverseGaussian(double mu, double lambda) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            double v = random.nextGaussian();
            double y = v * v;
            double x = mu + mu * mu * y / (2.0 * lambda) - mu / (2.0 * lambda) * Math.sqrt(4.0 * mu * lambda * y + mu * mu * y * y);
            double test = MathUtils.nextDouble();
            if (test <= mu / (mu + x)) {
                return x;
            }
            return mu * mu / x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nextFloat() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextFloat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextLong() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short nextShort() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextShort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextInt(n);
        }
    }

    public static double uniform(double low, double high) {
        return low + MathUtils.nextDouble() * (high - low);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(int[] array) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.shuffle(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(int[] array, int numberOfShuffles) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.shuffle(array, numberOfShuffles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] shuffled(int l) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.shuffled(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] sampleIndicesWithReplacement(int length) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            int[] result = new int[length];
            for (int i = 0; i < length; ++i) {
                result[i] = random.nextInt(length);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void permute(int[] array) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.permute(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] permuted(int l) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.permuted(l);
        }
    }

    public static double logHyperSphereVolume(int dimension, double radius) {
        return (double)dimension * (0.5723649429247001 + Math.log(radius)) + -GammaFunction.lnGamma((double)dimension / 2.0 + 1.0);
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static double round(double value, int sf) {
        NumberFormatter formatter = new NumberFormatter(sf);
        try {
            return NumberFormat.getInstance().parse(formatter.format(value)).doubleValue();
        }
        catch (ParseException e) {
            return value;
        }
    }
}

