/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.SingularValueDecompositionImpl;

public class Procrustes {
    private final RealMatrix R;
    private final RealMatrix T;
    private final double s;
    private final int rowDimension;
    private final int columnDimension;

    public Procrustes(RealMatrix X, RealMatrix Xstar, boolean allowTranslation, boolean allowDilation) {
        int i;
        this.rowDimension = X.getRowDimension();
        this.columnDimension = X.getColumnDimension();
        if (Xstar.getRowDimension() != this.rowDimension) {
            throw new IllegalArgumentException("X and Xstar do not have the same number of rows");
        }
        if (Xstar.getColumnDimension() != this.columnDimension) {
            throw new IllegalArgumentException("X and Xstar do not have the same number of columns");
        }
        Array2DRowRealMatrix J = new Array2DRowRealMatrix(this.rowDimension, this.rowDimension);
        if (allowTranslation) {
            for (i = 0; i < this.rowDimension; ++i) {
                J.setEntry(i, i, 1.0 - 1.0 / (double)this.rowDimension);
                for (int j = i + 1; j < this.rowDimension; ++j) {
                    J.setEntry(i, j, -1.0 / (double)this.rowDimension);
                    J.setEntry(j, i, -1.0 / (double)this.rowDimension);
                }
            }
        } else {
            for (i = 0; i < this.rowDimension; ++i) {
                J.setEntry(i, i, 1.0);
            }
        }
        RealMatrix C = Xstar.transpose().multiply(J.multiply(X));
        SingularValueDecompositionImpl SVD = new SingularValueDecompositionImpl(C);
        this.R = SVD.getV().multiply(SVD.getUT());
        double s = 1.0;
        if (allowDilation) {
            RealMatrix mat1 = Xstar.transpose().multiply(J.multiply(X.multiply(this.R)));
            RealMatrix mat2 = X.transpose().multiply(J.multiply(X));
            double numer = 0.0;
            double denom = 0.0;
            for (int i2 = 0; i2 < this.columnDimension; ++i2) {
                numer += mat1.getEntry(i2, i2);
                denom += mat2.getEntry(i2, i2);
            }
            s = numer / denom;
        }
        this.s = s;
        Array2DRowRealMatrix tmpT = new Array2DRowRealMatrix(this.columnDimension, 1);
        if (allowTranslation) {
            Array2DRowRealMatrix tmp = new Array2DRowRealMatrix(this.rowDimension, 1);
            for (int i3 = 0; i3 < this.rowDimension; ++i3) {
                tmp.setEntry(i3, 0, 1.0);
            }
            tmpT = Xstar.subtract(X.multiply(this.R).scalarMultiply(s)).transpose().scalarMultiply(1.0 / (double)this.rowDimension).multiply((RealMatrix)tmp);
        }
        this.T = tmpT;
    }

    public final RealMatrix getTranslation() {
        return this.T.copy();
    }

    public final double getDilation() {
        return this.s;
    }

    public final RealMatrix getR() {
        return this.R.copy();
    }

    public final RealMatrix procrustinate(RealMatrix X) {
        if (X.getRowDimension() != this.rowDimension) {
            throw new IllegalArgumentException("X does not have the expected number of rows");
        }
        if (X.getColumnDimension() != this.columnDimension) {
            throw new IllegalArgumentException("X does not have the expected number of columns");
        }
        Array2DRowRealMatrix tt = new Array2DRowRealMatrix(this.rowDimension, this.columnDimension);
        for (int i = 0; i < this.rowDimension; ++i) {
            tt.setRowMatrix(i, this.T.transpose());
        }
        return X.multiply(this.R).scalarMultiply(this.s).add((RealMatrix)tt);
    }

    public double[] procrustinate(double[] X) {
        if (X.length != this.columnDimension) {
            throw new IllegalArgumentException("X does not have the expected number of elements");
        }
        Array2DRowRealMatrix tmp = new Array2DRowRealMatrix(X);
        RealMatrix Xnew = tmp.multiply(this.R).scalarMultiply(this.s).add(this.T);
        return Xnew.getRow(0);
    }

    public static final RealMatrix procrustinate(RealMatrix X, RealMatrix Xstar, boolean allowTranslation, boolean allowDilation) {
        return new Procrustes(X, Xstar, allowTranslation, allowDilation).procrustinate(X);
    }
}

