/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.special.Gamma;

public class BetaDistribution
extends AbstractContinuousDistribution
implements Distribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private double alpha;
    private double beta;
    private double z;
    private final double solverAbsoluteAccuracy;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return BetaDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return 1.0;
        }
    };

    public BetaDistribution(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.z = Double.NaN;
        this.solverAbsoluteAccuracy = 1.0E-9;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    private void recomputeZ() {
        if (Double.isNaN(this.z)) {
            this.z = Gamma.logGamma((double)this.alpha) + Gamma.logGamma((double)this.beta) - Gamma.logGamma((double)(this.alpha + this.beta));
        }
    }

    @Override
    public double pdf(double x) {
        this.recomputeZ();
        if (x < 0.0 || x > 1.0) {
            return 0.0;
        }
        if (x == 0.0) {
            if (this.alpha < 1.0) {
                return Double.NaN;
            }
            return 0.0;
        }
        if (x == 1.0) {
            if (this.beta < 1.0) {
                return Double.NaN;
            }
            return 0.0;
        }
        double logX = Math.log(x);
        double log1mX = Math.log1p(-x);
        return Math.exp((this.alpha - 1.0) * logX + (this.beta - 1.0) * log1mX - this.z);
    }

    @Override
    public double logPdf(double x) {
        this.recomputeZ();
        if (x < 0.0 || x > 1.0) {
            return 0.0;
        }
        if (x == 0.0) {
            if (this.alpha < 1.0) {
                return Double.NaN;
            }
            return 0.0;
        }
        if (x == 1.0) {
            if (this.beta < 1.0) {
                return Double.NaN;
            }
            return 0.0;
        }
        double logX = Math.log(x);
        double log1mX = Math.log1p(-x);
        return (this.alpha - 1.0) * logX + (this.beta - 1.0) * log1mX - this.z;
    }

    @Override
    public double quantile(double y) {
        if (y == 0.0) {
            return 0.0;
        }
        if (y == 1.0) {
            return 1.0;
        }
        try {
            return super.inverseCumulativeProbability(y);
        }
        catch (MathException e) {
            return Double.NaN;
        }
    }

    protected double getInitialDomain(double p) {
        return p;
    }

    protected double getDomainLowerBound(double p) {
        return 0.0;
    }

    protected double getDomainUpperBound(double p) {
        return 1.0;
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        try {
            return Beta.regularizedBeta((double)x, (double)this.alpha, (double)this.beta);
        }
        catch (MathException e) {
            return Double.NaN;
        }
    }

    public double cumulativeProbability(double x) throws MathException {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        return Beta.regularizedBeta((double)x, (double)this.alpha, (double)this.beta);
    }

    public double cumulativeProbability(double x0, double x1) throws MathException {
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double mean() {
        return this.alpha / (this.alpha + this.beta);
    }

    @Override
    public double variance() {
        return this.alpha * this.beta / ((this.alpha + this.beta) * (this.alpha + this.beta) * (this.alpha + this.beta + 1.0));
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }
}

